package ru.yandex.autotests.directapi.darkside.datacontainers.http.request;

import java.util.Arrays;

/**
 * Created by pavryabov on 13.11.15.
 */
public class ExportRightsUidToCidRequest {

    String params = new String();

    static final String CID = "cid";

    static final String MIN_CID = "min_cid";

    static final String MAX_CID = "max_cid";

    public ExportRightsUidToCidRequest withCids(Long... cids) {
        Arrays.asList(cids).forEach(x -> {
            this.params += CID + '=' + x + '&';
        });
        return this;
    }

    public ExportRightsUidToCidRequest withMinCid(Long cid) {
        this.params += MIN_CID + '=' + cid + '&';
        return this;
    }

    public ExportRightsUidToCidRequest withMaxCid(Long cid) {
        this.params += MAX_CID + '=' + cid + '&';
        return this;
    }

    @Override
    public String toString() {
        return params;
    }
}
