package ru.yandex.autotests.directapi.darkside.datacontainers.http.request;

import java.util.HashMap;

/**
 * Created by omaz on 19.03.14.
 */
public class RetargetingForMetricaRequest extends HashMap<String, String> {
    public static final String CHUNK_COUNT = "chunk_count";
    public static final String CHUNK_NUM = "chunk_num";

    public RetargetingForMetricaRequest withChunkCount(Integer chunkCount) {
        put(CHUNK_COUNT, String.valueOf(chunkCount));
        return this;
    }

    public RetargetingForMetricaRequest withChunkNum(Integer chunkNum) {
        put(CHUNK_NUM, String.valueOf(chunkNum));
        return this;
    }

    public RetargetingForMetricaRequest withChunkCount(String chunkCount) {
        put(CHUNK_COUNT, chunkCount);
        return this;
    }

    public RetargetingForMetricaRequest withChunkNum(String chunkNum) {
        put(CHUNK_NUM, chunkNum);
        return this;
    }
}
