package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.dostup;

import com.google.gson.annotations.SerializedName;

import java.util.Map;

/**
 * Класс, опысывающий ответ ручки {@code /idm/info}.
 * Пример json'а после тела класса
 */
public class DostupInfoResponse {
    @SerializedName("roles")
    private Roles roles;
    @SerializedName("fields")
    private Object[] fields;
    @SerializedName("code")
    private Integer code;

    public static class Roles {
        @SerializedName("slug")
        private String slug;
        @SerializedName("name")
        private String name;
        @SerializedName("values")
        private Map<String, Object> values;

        public String getSlug() {
            return slug;
        }

        public void setSlug(String slug) {
            this.slug = slug;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, Object> getValues() {
            return values;
        }

        public void setValues(Map<String, Object> values) {
            this.values = values;
        }
    }

    public Roles getRoles() {
        return roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public Object[] getFields() {
        return fields;
    }

    public void setFields(Object[] fields) {
        this.fields = fields;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
/*
{
    "code": 0,
    "fields": [
        {
            "name": "Паспортный логин",
            "required": true,
            "slug": "passport-login"
        }
    ],
    "roles": {
        "name": "роль",
        "slug": "direct",
        "values": {
            "internal_ad_admin": "администратор внутренней рекламы",
            "internal_ad_manager": "менеджер внутренней рекламы",
            "main_manager_for_client": {
                "fields": [
                    {
                        "name": "ClientID клиента",
                        "required": true,
                        "slug": "client_id",
                        "type": "charfield"
                    }
                ],
                "name": "главный менеджер клиента"
            },
            "manager": "менеджер",
            "manager_for_client": {
                "fields": [
                    {
                        "name": "ClientID клиента",
                        "required": true,
                        "slug": "client_id",
                        "type": "charfield"
                    },
                    {
                        "slug": "passport-login",
                        "type": "undo"
                    }
                ],
                "name": "менеджер с доступом к клиенту"
            },
            "media": "медиапланер",
            "placer": "вешальщик",
            "super": "супер-пользователь",
            "superreader": "суперсмотритель",
            "superteamleader": "начальник отдела",
            "support": "саппорт",
            "teamleader": "тимлидер"
        }
    }
}
*/

