package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.json.dostup;

import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.model.Role;

import java.util.ArrayList;
import java.util.Map;

/**
 * Created by omaz on 13.02.14.
 * Структура для роли, часть ответа к idm/get_all_roles, get_user_roles
 */
public class RoleResponseData extends ArrayList {
    String roleName;
    String passportLogin;

    public String getRoleName() {
        try {
            return (String) ((Map) this.get(0)).get("direct");
        } catch (Exception e) {
            throw new DarkSideException("Не удалось получить занчение поля direct", e);
        }
    }

    public String getPassportLogin() {
        try {
            return (String) ((Map) this.get(1)).get("passport-login");
        } catch (Exception e) {
            throw new DarkSideException("Не удалось получить занчение поля passport-login", e);
        }
    }

    public RoleResponseData withRoleName(Role role) {
        this.roleName = role.getRoleName();
        return this;
    }

    public RoleResponseData withPassportLogin(String passportLogin) {
        this.passportLogin = passportLogin;
        return this;
    }
}
