package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.tsv;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by omaz on 23.01.14.
 */
public class ActiveBannersResponse {
    List<Long> banners;

    public ActiveBannersResponse(String tsv) {
        banners = new ArrayList<>();
        String[] tsvLines = tsv.split("\n");
        for (String line : tsvLines) {
            if (!line.equals("#End") && !line.equals("#bid")) {
                addBanner(Long.valueOf(line));
            }
        }
    }

    public List<Long> getBanners() {
        return banners;
    }

    public void addBanner(Long bid) {
        banners.add(bid);
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }

}
