package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.tsv;

import org.apache.commons.lang.StringEscapeUtils;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertTrue;

/**
 * Created by omaz on 24.01.14.
 */
public class AllBannersPhrasesResponse {
    private List<PhraseData> phrases;
    private int countOfPhraseDataInResponse;


    private AllBannersPhrasesResponse(List<PhraseData> phrases, int countOfPhraseDataInResponse) {
        this.phrases = phrases;
        this.countOfPhraseDataInResponse = countOfPhraseDataInResponse;
    }

    /*
        Добавляем в список баннеров, id которых содержиться в bids
     */
    public static AllBannersPhrasesResponse parseAllBannersPhrasesResponse(InputStream inputStream, List<Long> bids) {
        List<PhraseData> phrases = new ArrayList<>();
        int countOfPhraseDataInResponse = 0;
        Pattern beginLinePattern = Pattern.compile("\\d* LastChange: \\d* LastBid: \\d*");
        Pattern pattern = Pattern.compile("(\\d*)\t(.*)\t(.*)\t(.*)\t(.*)\t(.*)\t(1|0)\t(.*)\t(\\d*)\t(.*)\t(0|1)\t(\\d*)\t([\\S ]*)\t([\\S ]*)\t(\\d*)\t(0|1)");

        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream))) {
            String line = br.readLine();
            Matcher matcher = beginLinePattern.matcher(line);
            assertTrue("Неверное начало ответа: " + line, matcher.matches());

            line = br.readLine();
            while (line != null && !line.equals("__END__")) {
                if (!line.contains("deleted")) {
                    line = StringEscapeUtils.unescapeHtml(line);
                    matcher = pattern.matcher(line);
                    assertTrue("Ошибка парсинга ответа: не удалось распарсить строку " + line, matcher.matches());

                    try {
                        PhraseData phraseData = new PhraseData(
                                Long.valueOf(matcher.group(1)),
                                matcher.group(2),
                                matcher.group(3),
                                matcher.group(4),
                                matcher.group(5),
                                matcher.group(6),
                                Integer.valueOf(matcher.group(7)),
                                matcher.group(8),
                                Integer.valueOf(matcher.group(9)),
                                matcher.group(10),
                                Integer.valueOf(matcher.group(11)),
                                Integer.valueOf(matcher.group(12)),
                                matcher.group(13),
                                matcher.group(14),
                                Long.valueOf(matcher.group(15)),
                                Integer.valueOf(matcher.group(16))
                        );

                        countOfPhraseDataInResponse++;
                        if (bids.contains(phraseData.bid)) {
                            phrases.add(phraseData);
                        }
                    } catch (Exception e) {
                        throw new DarkSideException(line, e);
                    }
                }
                line = br.readLine();
            }
        } catch (IOException e) {
            throw new DarkSideException("Ошибка парсинга TSV: не удалось прочесть строку с потока", e);
        }
        return new AllBannersPhrasesResponse(phrases, countOfPhraseDataInResponse);
    }


    public PhraseData getPhraseData(Long bid) {
        return selectFirst(this.phrases, having(on(PhraseData.class).getBid(), equalTo(bid)));
    }

    public int getCountOfPhraseDataInResponse() {
        return countOfPhraseDataInResponse;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }

    public static class PhraseData {
        Long bid;
        String lastChange;
        String title;
        String href;
        String body;
        String geo;
        Integer archived;
        String compositeId;
        Integer clientID;
        String locale;
        Integer flag;
        Integer cid;
        String campaignMinusWords;
        String groupMinusWords;
        Long bannerID;
        Integer broadmatch;

        public PhraseData() {
        }

        public PhraseData(Long bid,
                          String lastChange,
                          String title,
                          String href,
                          String body,
                          String geo,
                          Integer archived,
                          String compositeId,
                          Integer clientID,
                          String locale,
                          Integer flag,
                          Integer cid,
                          String minusWords,
                          String groupMinusWords,
                          Long bannerID,
                          Integer broadmatch) {
            this.bid = bid;
            this.lastChange = lastChange;
            this.title = title;
            this.href = href;
            this.body = body;
            this.geo = geo;
            this.compositeId = compositeId;
            this.archived = archived;
            this.clientID = clientID;
            this.locale = locale;
            this.flag = flag;
            this.cid = cid;
            this.campaignMinusWords = minusWords;
            this.groupMinusWords = groupMinusWords;
            this.bannerID = bannerID;
            this.broadmatch = broadmatch;
        }

        //region getters and setters
        public String getGroupMinusWords() {
            return groupMinusWords;
        }

        public void setGroupMinusWords(String groupMinusWords) {
            this.groupMinusWords = groupMinusWords;
        }

        public String getLastChange() {
            return lastChange;
        }

        public void setLastChange(String lastChange) {
            this.lastChange = lastChange;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getHref() {
            return href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getBody() {
            return body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getGeo() {
            return geo;
        }

        public void setGeo(String geo) {
            this.geo = geo;
        }

        public Integer getArchived() {
            return archived;
        }

        public void setArchived(Integer archived) {
            this.archived = archived;
        }

        public Integer getClientID() {
            return clientID;
        }

        public void setClientID(Integer clientID) {
            this.clientID = clientID;
        }

        public String getCampaignMinusWords() {
            return campaignMinusWords;
        }

        public void setCampaignMinusWords(String campaignMinusWords) {
            this.campaignMinusWords = campaignMinusWords;
        }

        public Long getBannerID() {
            return bannerID;
        }

        public void setBannerID(Long bannerID) {
            this.bannerID = bannerID;
        }

        public Integer getBroadmatch() {
            return broadmatch;
        }

        public void setBroadmatch(Integer broadmatch) {
            this.broadmatch = broadmatch;
        }

        public Long getBid() {
            return bid;
        }

        public void setBid(Long bid) {
            this.bid = bid;
        }

        public String getCompositeId() {
            return compositeId;
        }

        public void setCompositeId(String compositeId) {
            this.compositeId = compositeId;
        }

        public String getLocale() {
            return locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public Integer getFlag() {
            return flag;
        }

        public void setFlag(Integer flag) {
            this.flag = flag;
        }

        public Integer getCid() {
            return cid;
        }

        public void setCid(Integer cid) {
            this.cid = cid;
        }
        //endregion
    }

}



