package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.tsv;

import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by pavryabov on 13.11.15.
 */
public class ExportRightsUidToCidResponse {

    private List<UidCidPair> uidCidPairs;

    public ExportRightsUidToCidResponse() {
        uidCidPairs = new ArrayList<>();
    }

    public List<UidCidPair> getUidCidPairs() {
        return uidCidPairs;
    }

    public static class UidCidPair {
        Long uid;
        Long cid;

        public UidCidPair() {
        }

        public UidCidPair(Long uid, Long cid) {
            this.uid = uid;
            this.cid = cid;
        }

        public Long getCid() {
            return cid;
        }

        public void setCid(Long cid) {
            this.cid = cid;
        }

        public Long getUid() {
            return uid;
        }

        public void setUid(Long uid) {
            this.uid = uid;
        }
    }

    /**
     * Создание объекта данных из строки в формате TSV
     */
    public ExportRightsUidToCidResponse(String tsv) {
        uidCidPairs = new ArrayList<>();
        String[] tsvLines = tsv.split("\n");
        Pattern pattern = Pattern.compile("(\\d*)\t(\\d*)");
        for (String line : tsvLines) {
            if (!line.equals("#End") && !line.equals("#uid\tcid")) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches())
                    add(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)));
                else
                    throw new DarkSideException("Ошибка парсинга TSV: не удалось распарсить строку " + line);
            }
        }
    }

    public ExportRightsUidToCidResponse add(Long uid, Long cid) {
        uidCidPairs.add(new UidCidPair(uid, cid));
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
