package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.tsv;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by omaz on 09.07.14.
 */
public class GetBannersPhrasesResponse {

    List<Phrase> phrases;

    public static class Phrase {
        Long cid;
        Long bid;
        Long bidsId;
        String phrase;

        public Long getCid() {
            return cid;
        }

        public void setCid(Long cid) {
            this.cid = cid;
        }

        public Long getBid() {
            return bid;
        }

        public void setBid(Long bid) {
            this.bid = bid;
        }

        public Long getBidsId() {
            return bidsId;
        }

        public void setBidsId(Long bidsId) {
            this.bidsId = bidsId;
        }

        public String getPhrase() {
            return phrase;
        }

        public void setPhrase(String phrase) {
            this.phrase = phrase;
        }

        @Override
        public String toString() {
            return JsonUtils.toString(this);
        }
    }

    public GetBannersPhrasesResponse(String tsv) {
        phrases = new ArrayList<>();
        String[] tsvLines = tsv.split("\n");
        Pattern pattern = Pattern.compile("(\\d+)\t(\\d+)\t(\\d+)\t(.*)");
        for (String line : tsvLines) {
            if (!line.equals("#End") && !line.equals("#cid\tbid\tbids_id\tphrase")) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    Phrase phrase = new Phrase();
                    phrase.setCid(Long.valueOf(matcher.group(1)));
                    phrase.setBid(Long.valueOf(matcher.group(2)));
                    phrase.setBidsId(Long.valueOf(matcher.group(3)));
                    phrase.setPhrase(matcher.group(4));
                    phrases.add(phrase);
                } else
                    throw new DarkSideException("Ошибка парсинга ответа: не удалось распарсить строку " + line);
            }
        }
    }

    public List<Phrase> getPhrases() {
        return phrases;
    }
}
