package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.tsv;

import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by semkagtn on 11/26/14.
 */
public class RetargetingSegmentsForMetricaResponse {

    private List<Segment> segments;

    public RetargetingSegmentsForMetricaResponse(String responseText) {
        segments = new ArrayList<>();
        Pattern pattern = Pattern.compile("(\\d+\t\\d+\n)+#END\n?");
        Matcher matcher = pattern.matcher(responseText);
        if (matcher.matches()) {
            pattern = Pattern.compile("(\\d+)\t(\\d+)\n");
            matcher = pattern.matcher(responseText);
            while (matcher.find()) {
                long segmentId = Long.valueOf(matcher.group(1));
                int interval = Integer.valueOf(matcher.group(2));
                segments.add(new Segment(segmentId, interval));
            }
        } else {
            throw new DarkSideException("Ошибка парсинга ответа. Не удалось распарсить " + responseText);
        }
    }

    public static class Segment {

        private long segmentId;
        private int interval;

        public Segment(long segmentId, int interval) {
            this.segmentId = segmentId;
            this.interval = interval;
        }

        public long getSegmentId() {
            return segmentId;
        }

        public void setSegmentId(long segmentId) {
            this.segmentId = segmentId;
        }

        public int getInterval() {
            return interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        @Override
        public String toString() {
            return JsonUtils.toString(this);
        }
    }

    public List<Segment> getSegments() {
        return segments;
    }
}
