package ru.yandex.autotests.directapi.darkside.datacontainers.http.response.yaml;

import java.util.List;

import org.yaml.snakeyaml.Yaml;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * User: omaz
 * Date: 10.10.13
 */
public class CampaignsForMetricaResponse {
    CampaignsForMetricaResponseYamlContainer responceContainer;
    Yaml yaml = new Yaml();

    public static class CampaignsForMetricaResponseYamlContainer {
        public List<CampaignData> campaigns;
    }

    public static class CampaignData {
        public String OrderID;
        public String cid;
        public String domain;
        public String fil;
        public String name;
        public String shows;

        public Long getCid() {
            if (cid != null)
                return Long.valueOf(cid);
            else return null;
        }

        public void setCid(int cid) {
            this.cid = String.valueOf(cid);
        }

        public void setOrderID(String orderID) {
            OrderID = orderID;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setFil(String fil) {
            this.fil = fil;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setShows(String shows) {
            this.shows = shows;
        }
    }

    public CampaignsForMetricaResponse(String responceText) {
        responceContainer = yaml.loadAs(responceText.replace("--- \n", "campaigns: \n"), CampaignsForMetricaResponseYamlContainer.class);
    }

    public List<CampaignData> getCampaignList() {
        return responceContainer.campaigns;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
