package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget;

import java.math.BigInteger;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Author: xy6er
 * Date: 21.01.15
 */
public class AutobudgetPricesSetRequest {

    @JsonProperty("GroupExportID")
    public Long groupExportID;

    @JsonProperty("PhraseID")
    public BigInteger phraseID;

    @JsonProperty("price")
    public float price;

    @JsonProperty("context_price")
    public float contextPrice;

    @JsonProperty("currency")
    public int currency;

    @JsonProperty("ContextType")
    public int contextType;

    public AutobudgetPricesSetRequest() {
    }

    public AutobudgetPricesSetRequest(Long groupExportID, BigInteger phraseID, float price,
                                      float contextPrice, int currency, int contextType) {
        this.groupExportID = groupExportID;
        this.phraseID = phraseID;
        this.price = price;
        this.contextPrice = contextPrice;
        this.currency = currency;
        this.contextType = contextType;
    }

    public Long getGroupExportID() {
        return groupExportID;
    }

    public void setGroupExportID(Long groupExportID) {
        this.groupExportID = groupExportID;
    }

    public BigInteger getPhraseID() {
        return phraseID;
    }

    public void setPhraseID(BigInteger phraseID) {
        this.phraseID = phraseID;
    }

    public float getPrice() {
        return price;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public float getContextPrice() {
        return contextPrice;
    }

    public void setContextPrice(float contextPrice) {
        this.contextPrice = contextPrice;
    }

    public int getCurrency() {
        return currency;
    }

    public void setCurrency(int currency) {
        this.currency = currency;
    }

    public int getContextType() {
        return contextType;
    }

    public void setContextType(int contextType) {
        this.contextType = contextType;
    }

}
