package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget;

import java.math.BigInteger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;

/**
 * Author: xy6er
 * Date: 21.01.15
 */
public class AutobudgetPricesSetResponse implements Comparable<AutobudgetPricesSetResponse> {

    @JsonProperty("code")
    private Integer code;

    @JsonProperty("msg")
    private String msg;

    @JsonProperty("GroupExportID")
    public Long groupExportID;

    @JsonProperty("PhraseID")
    public BigInteger phraseID;

    public AutobudgetPricesSetResponse() {
    }

    public AutobudgetPricesSetResponse(Integer code, String msg, Long groupExportID, BigInteger phraseID) {
        this.code = code;
        this.msg = msg;
        this.groupExportID = groupExportID;
        this.phraseID = phraseID;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Long getGroupExportID() {
        return groupExportID;
    }

    public void setGroupExportID(Long groupExportID) {
        this.groupExportID = groupExportID;
    }

    public BigInteger getPhraseID() {
        return phraseID;
    }

    public void setPhraseID(BigInteger phraseID) {
        this.phraseID = phraseID;
    }

    @Override
    public int compareTo(AutobudgetPricesSetResponse o) {
        return ComparisonChain.start()
                .compare(groupExportID, o.getGroupExportID())
                .compare(phraseID, o.getPhraseID())
                .compare(code, o.getCode())
                .compare(msg, o.getMsg())
                .result();
    }

}
