package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.HashMap;

/**
 * билдер параметров для ordersNotExceededBudget
 */
public class OrdersNotExceededBudgetParams {
    @JsonUnwrapped
    HashMap<Integer, AlertData> data;

    public class AlertData {
        Integer problems;
        Integer overdraft;

        public AlertData(Integer problems, Integer overdraft) {
            this.problems = problems;
            this.overdraft = overdraft;
        }

        @JsonProperty
        public Integer getProblems() {
            return problems;
        }

        @JsonProperty
        public Integer getOverdraft() {
            return overdraft;
        }
    }

    public OrdersNotExceededBudgetParams() {
        data = new HashMap<Integer, AlertData>();
    }

    public OrdersNotExceededBudgetParams withAlert(Integer orderID, Integer problems, Integer overdraft) {
        this.data.put(orderID, new AlertData(problems, overdraft));
        return this;
    }

    @JsonAnyGetter
    public HashMap<Integer, AlertData> getData() {
        return data;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
