package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import java.util.HashMap;

/**
 * Created by omaz on 17.02.14.
 * билдер параметров для ordersWithCpaWarnings
 */
public class OrdersWithCpaWarningsParams {
    @JsonUnwrapped
    HashMap<Integer, AlertData> data;

    public class AlertData {
        //отклонение цены конверсии
        Integer cpa;
        //отклонение конверсии
        Integer apc;

        public AlertData(Integer cpa, Integer apc) {
            this.cpa = cpa;
            this.apc = apc;
        }

        @JsonProperty
        public Integer getCpa() {
            return cpa;
        }

        @JsonProperty
        public Integer getApc() {
            return apc;
        }
    }

    public OrdersWithCpaWarningsParams() {
        data = new HashMap<Integer, AlertData>();
    }

    public OrdersWithCpaWarningsParams withAlert(Integer orderID, Integer cpa, Integer apc) {
        this.data.put(orderID, new AlertData(cpa, apc));
        return this;
    }

    @JsonAnyGetter
    public HashMap<Integer, AlertData> getData() {
        return data;
    }
}
