package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudgetoptimizedby;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by pavryabov on 19.08.15.
 */
public class AutobudgetOptimizedByRequest {

    @JsonProperty("OrderID")
    private Long orderID;

    @JsonProperty("GroupExportID")
    private Long groupExportID;

    @JsonProperty("PhraseID")
    private Long phraseID;

    @JsonProperty("OptimizedBy")
    private String optimizedBy;

    public Long getOrderID() {
        return orderID;
    }

    public void setOrderID(Long orderID) {
        this.orderID = orderID;
    }

    public Long getGroupExportID() {
        return groupExportID;
    }

    public void setGroupExportID(Long groupExportID) {
        this.groupExportID = groupExportID;
    }

    public Long getPhraseID() {
        return phraseID;
    }

    public void setPhraseID(Long phraseID) {
        this.phraseID = phraseID;
    }

    public String getOptimizedBy() {
        return optimizedBy;
    }

    public void setOptimizedBy(String optimizedBy) {
        this.optimizedBy = optimizedBy;
    }

    public AutobudgetOptimizedByRequest withOrderID(Long orderID) {
        this.setOrderID(orderID);
        return this;
    }

    public AutobudgetOptimizedByRequest withGroupExportID(Long groupExportID) {
        this.setGroupExportID(groupExportID);
        return this;
    }

    public AutobudgetOptimizedByRequest withPhraseID(Long phraseID) {
        this.setPhraseID(phraseID);
        return this;
    }

    public AutobudgetOptimizedByRequest withOptimizedBy(String optimizedBy) {
        this.setOptimizedBy(optimizedBy);
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
