package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudgetoptimizedby;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by pavryabov on 19.08.15.
 */
public class AutobudgetOptimizedByResponse {

    public static final int CODE_UNKNOWN_SHARD = 1;
    public static final int CODE_UNKNOWN_ID = 2;
    public static final int CODE_MUST_BE_GREATER_ZERO = 3;
    public static final int CODE_INVALID_OPTIMIZED_BY = 4;
    public static final int CODE_UNKNOWN_ORDER_ID = 5;

    public static final String MSG_UNKNOWN_SHARD = "unknown shard";
    public static final String MSG_UNKNOWN_IDS = "unknown OrderID, GroupExportID or PhraseID";
    public static final String MSG_ORDER_ID_MUST_BE_GREATER_ZERO = "OrderID must be greater than zero";
    public static final String MSG_IDS_MUST_BE_GREATER_ZERO = "OrderID, GroupExportID, PhraseID must be greater than zero";
    public static final String MSG_INVALID_OPTIMIZED_BY = "OptimizedBy must be CPC or CPA";
    public static final String MSG_UNKNOWN_ORDER_ID = "unknown OrderID";

    @JsonProperty("OrderID")
    private Long orderID;

    @JsonProperty("GroupExportID")
    private Long groupExportID;

    @JsonProperty("PhraseID")
    private Long phraseID;

    @JsonProperty("code")
    private Integer code;

    @JsonProperty("msg")
    private String msg;

    public Long getOrderID() {
        return orderID;
    }

    public void setOrderID(Long orderID) {
        this.orderID = orderID;
    }

    public Long getGroupExportID() {
        return groupExportID;
    }

    public void setGroupExportID(Long groupExportID) {
        this.groupExportID = groupExportID;
    }

    public Long getPhraseID() {
        return phraseID;
    }

    public void setPhraseID(Long phraseID) {
        this.phraseID = phraseID;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public AutobudgetOptimizedByResponse withOrderID(Long orderID) {
        this.setOrderID(orderID);
        return this;
    }

    public AutobudgetOptimizedByResponse withGroupExportID(Long groupExportID) {
        this.setGroupExportID(groupExportID);
        return this;
    }

    public AutobudgetOptimizedByResponse withPhraseID(Long phraseID) {
        this.setPhraseID(phraseID);
        return this;
    }

    public AutobudgetOptimizedByResponse withCode(int code) {
        this.setCode(code);
        return this;
    }

    public AutobudgetOptimizedByResponse withMsg(String msg) {
        this.setMsg(msg);
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
