package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by buhter on 14/02/2017.
 */
public class NotifyAgencyAdditionalCurrenciesJSONRequest {
    @SerializedName("ClientID")
    private Long clientId;
    @SerializedName("AdditionalCurrencies")
    private List<AdditionalCurrency> additionalCurrencies;

    public Long getClientId() {
        return clientId;
    }

    public List<AdditionalCurrency> getAdditionalCurrencies() {
        return additionalCurrencies;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public void setAdditionalCurrencies(List<AdditionalCurrency> additionalCurrencies) {
        this.additionalCurrencies = additionalCurrencies;
    }

    public NotifyAgencyAdditionalCurrenciesJSONRequest withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public NotifyAgencyAdditionalCurrenciesJSONRequest withAdditionalCurrencies(
            List<AdditionalCurrency> additionalCurrencies) {
        this.additionalCurrencies = additionalCurrencies;
        return this;
    }

    public NotifyAgencyAdditionalCurrenciesJSONRequest withAdditionalCurrency(
            AdditionalCurrency additionalCurrency) {
        if (this.additionalCurrencies == null) {
            this.additionalCurrencies = new ArrayList<>();
        }
        this.additionalCurrencies.add(additionalCurrency);
        return this;
    }

    public static class AdditionalCurrency {
        @SerializedName("Currency")
        private String currency;
        @SerializedName("ExpireDate")
        private String expireDate;

        public String getCurrency() {
            return currency;
        }

        public AdditionalCurrency withCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public String getExpireDate() {
            return expireDate;
        }

        public AdditionalCurrency withExpireDate(String expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public void setExpireDate(String expireDate) {
            this.expireDate = expireDate;
        }
    }
}

