package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient;

import java.math.BigDecimal;

import com.google.gson.annotations.SerializedName;

public class NotifyCashback2JSONRequest {

    @SerializedName("ClientID")
    private Long ClientID;

    @SerializedName("ServiceID")
    private Integer serviceId;

    @SerializedName("IsoCurrency")
    private String balanceCurrency;

    @SerializedName("Bonus")
    private BigDecimal cashbackBonus;

    @SerializedName("ConsumedBonus")
    private BigDecimal cashbackConsumedBonus;

    public Long getClientID() {
        return ClientID;
    }

    public NotifyCashback2JSONRequest withClientID(Long clientID) {
        ClientID = clientID;
        return this;
    }

    public Integer getServiceId() {
        return serviceId;
    }

    public NotifyCashback2JSONRequest withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String getBalanceCurrency() {
        return balanceCurrency;
    }

    public NotifyCashback2JSONRequest withBalanceCurrency(String balanceCurrency) {
        this.balanceCurrency = balanceCurrency;
        return this;
    }

    public BigDecimal getCashbackBonus() {
        return cashbackBonus;
    }

    public NotifyCashback2JSONRequest withCashbackBonus(BigDecimal cashbackBonus) {
        this.cashbackBonus = cashbackBonus;
        return this;
    }

    public BigDecimal getCashbackConsumedBonus() {
        return cashbackConsumedBonus;
    }

    public NotifyCashback2JSONRequest withCashbackConsumedBonus(BigDecimal cashbackConsumedBonus) {
        this.cashbackConsumedBonus = cashbackConsumedBonus;
        return this;
    }
}
