package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient;

import com.google.gson.annotations.SerializedName;
import org.joda.time.DateTime;

import java.text.SimpleDateFormat;

/**
 * Created by buhter on 14/02/2017.
 */
public class NotifyClient2JSONRequest {

    @SerializedName("BusinessUnit")
    private Integer businessUnit;
    @SerializedName("HasEquivalentOrBrandClients")
    private Integer brand;
    @SerializedName("CanBeForceCurrencyConverted")
    private Integer canBeForceCurrencyConverted;
    @SerializedName("ClientCurrency")
    private String clientCurrency;
    @SerializedName("ClientID")
    private Long ClientID;
    @SerializedName("MigrateToCurrencyDone")
    private Integer migrateToCurrencyDone;
    @SerializedName("MinPaymentTerm")
    private String minPaymentTerm;
    @SerializedName("NonResident")
    private Integer nonResident;
    @SerializedName("OverdraftBan")
    private Integer overdraftBan;
    @SerializedName("OverdraftLimit")
    private Float overdraftLimit;
    @SerializedName("OverdraftSpent")
    private Float overdraftSpent;
    @SerializedName("Tid")
    private String tid;

    public Integer getBusinessUnit() {
        return businessUnit;
    }

    public NotifyClient2JSONRequest withBusinessUnit(Boolean isBusinessUnit) {
        if (isBusinessUnit == null) {
            return this;
        }
        this.businessUnit = isBusinessUnit ? 1 : 0;
        return this;
    }

    public Integer getBrand() {
        return brand;
    }

    public NotifyClient2JSONRequest withBrand(Boolean isBrand) {
        if (isBrand == null) {
            return this;
        }
        this.brand = isBrand ? 1 : 0;
        return this;
    }

    public Integer getCanBeForceCurrencyConverted() {
        return canBeForceCurrencyConverted;
    }

    public NotifyClient2JSONRequest withCanBeForceCurrencyConverted(Boolean canBeForceCurrencyConverted) {
        if (canBeForceCurrencyConverted == null) {
            return this;
        }
        this.canBeForceCurrencyConverted = canBeForceCurrencyConverted ? 1 : 0;
        return this;
    }

    public String getClientCurrency() {
        return clientCurrency;
    }

    public NotifyClient2JSONRequest withClientCurrency(String clientCurrency) {
        this.clientCurrency = clientCurrency;
        return this;
    }

    public Long getClientID() {
        return ClientID;
    }

    public NotifyClient2JSONRequest withClientID(Long clientID) {
        ClientID = clientID;
        return this;
    }

    public Integer getMigrateToCurrencyDone() {
        return migrateToCurrencyDone;
    }

    public NotifyClient2JSONRequest withMigrateToCurrencyDone(Boolean isMigrateToCurrencyDone) {
        if (isMigrateToCurrencyDone == null) {
            return this;
        }
        this.migrateToCurrencyDone = isMigrateToCurrencyDone ? 1 : 0;
        return this;
    }

    public Integer getOverdraftBan() {
        return overdraftBan;
    }

    public NotifyClient2JSONRequest withOverdraftBan(Boolean isOverdraftBan) {
        if (isOverdraftBan == null) {
            return this;
        }
        this.overdraftBan = isOverdraftBan ? 1 : 0;
        return this;
    }

    public Float getOverdraftLimit() {
        return overdraftLimit;
    }

    public NotifyClient2JSONRequest withOverdraftLimit(Float overdraftLimit) {
        this.overdraftLimit = overdraftLimit;
        return this;
    }

    public Float getOverdraftSpent() {
        return overdraftSpent;
    }

    public NotifyClient2JSONRequest withOverdraftSpent(Float overdraftSpent) {
        this.overdraftSpent = overdraftSpent;
        return this;
    }

    public String getTid() {
        return tid;
    }

    public NotifyClient2JSONRequest withTid(String tid) {
        this.tid = tid;
        return this;
    }

    public void setBusinessUnit(Integer businessUnit) {
        this.businessUnit = businessUnit;
    }

    public void setCanBeForceCurrencyConverted(Integer canBeForceCurrencyConverted) {
        this.canBeForceCurrencyConverted = canBeForceCurrencyConverted;
    }

    public void setClientCurrency(String clientCurrency) {
        this.clientCurrency = clientCurrency;
    }

    public void setClientID(Long clientID) {
        ClientID = clientID;
    }

    public void setMigrateToCurrencyDone(Integer migrateToCurrencyDone) {
        this.migrateToCurrencyDone = migrateToCurrencyDone;
    }

    public void setOverdraftBan(Integer overdraftBan) {
        this.overdraftBan = overdraftBan;
    }

    public void setOverdraftLimit(Float overdraftLimit) {
        this.overdraftLimit = overdraftLimit;
    }

    public void setOverdraftSpent(Float overdraftSpent) {
        this.overdraftSpent = overdraftSpent;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getMinPaymentTerm() {
        return minPaymentTerm;
    }

    public NotifyClient2JSONRequest withMinPaymentTerm(String minPaymentTerm) {
        this.minPaymentTerm = minPaymentTerm;
        return this;
    }

    public Integer getNonResident() {
        return nonResident;
    }

    public NotifyClient2JSONRequest withNonResident(Boolean isNonResident) {
        if (isNonResident == null) {
            return this;
        }
        this.nonResident = isNonResident ? 1 : 0;
        return this;
    }

    public void setMinPaymentTerm(String minPaymentTerm) {
        this.minPaymentTerm = minPaymentTerm;
    }

    public void setNonResident(Integer nonResident) {
        this.nonResident = nonResident;
    }

    public NotifyClient2JSONRequest defaultParams() {
        return this.withClientID(0l)
                .withTid("0")
                .withOverdraftLimit(0.0f)
                .withOverdraftSpent(0.0f)
                .withMinPaymentTerm("")
                .withOverdraftBan(false)
                .withNonResident(false)
                .withMigrateToCurrencyDone(false)
                .withCanBeForceCurrencyConverted(false);
    }

    public NotifyClient2JSONRequest withTimestamp() {
        return this.withTimestamp(DateTime.now());
    }

    public NotifyClient2JSONRequest withTimestamp(DateTime date) {
        SimpleDateFormat timestampDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return this.withTid(timestampDateFormat.format(date.toDate()));
    }
}

