package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient;

import java.text.SimpleDateFormat;

import com.google.gson.annotations.SerializedName;
import org.joda.time.DateTime;

/**
 * Created by buhter on 14/02/2017.
 */
public class NotifyOrder2JSONRequest {

    public static final int DIRECT_SERVICE_ID = 7;
    public static final int BAYAN_SERVICE_ID = 77;

    @SerializedName("ServiceID")
    private int serviceId;
    @SerializedName("ServiceOrderID")
    private Long serviceOrderId;
    @SerializedName("Tid")
    private String tid;
    @SerializedName("ConsumeQty")
    private String consumeQty;
    @SerializedName("ConsumeAmount")
    private String consumeAmount;
    @SerializedName("ProductCurrency")
    private String productCurrency;
    @SerializedName("ConsumeCurrency")
    private String consumeCurrency;
    @SerializedName("Certificate")
    private Integer certificate;
    @SerializedName("ConsumeMoneyQty")
    private String consumeMoneyQty;
    @SerializedName("CompletionFixedMoneyQty")
    private String completionFixedMoneyQty;
    @SerializedName("CompletionFixedQty")
    private String completionFixedQty;
    @SerializedName("TotalConsumeQty")
    private String totalConsumeQty;

    public int getServiceId() {
        return serviceId;
    }

    public Long getServiceOrderId() {
        return serviceOrderId;
    }

    public String getTid() {
        return tid;
    }

    public String getConsumeQty() {
        return consumeQty;
    }

    public String getConsumeAmount() {
        return consumeAmount;
    }

    public String getProductCurrency() {
        return productCurrency;
    }

    public String getConsumeCurrency() {
        return consumeCurrency;
    }

    public Integer getCertificate() {
        return certificate;
    }

    public String getConsumeMoneyQty() {
        return consumeMoneyQty;
    }

    public String getCompletionFixedMoneyQty() {
        return completionFixedMoneyQty;
    }

    public String getCompletionFixedQty() {
        return completionFixedQty;
    }

    public String getTotalConsumeQty() {
        return totalConsumeQty;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public void setServiceOrderId(Long serviceOrderId) {
        this.serviceOrderId = serviceOrderId;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public void setConsumeQty(String consumeQty) {
        this.consumeQty = consumeQty;
    }

    public void setConsumeQty(Float consumeQty) {
        this.consumeQty = consumeQty.toString();
    }

    public void setConsumeAmount(String consumeAmount) {
        this.consumeAmount = consumeAmount;
    }

    public void setProductCurrency(String productCurrency) {
        this.productCurrency = productCurrency;
    }

    public void setConsumeCurrency(String consumeCurrency) {
        this.consumeCurrency = consumeCurrency;
    }

    public void setCertificate(Integer certificate) {
        this.certificate = certificate;
    }

    public void setConsumeMoneyQty(String consumeMoneyQty) {
        this.consumeMoneyQty = consumeMoneyQty;
    }

    public void setCompletionFixedMoneyQty(String completionFixedMoneyQty) {
        this.completionFixedMoneyQty = completionFixedMoneyQty;
    }

    public void setCompletionFixedQty(String completionFixedQty) {
        this.completionFixedQty = completionFixedQty;
    }

    public void setTotalConsumeQty(String totalConsumeQty) {
        this.totalConsumeQty = totalConsumeQty;
    }

    public NotifyOrder2JSONRequest withServiceId(int serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public NotifyOrder2JSONRequest withServiceOrderId(Long serviceOrderId) {
        this.serviceOrderId = serviceOrderId;
        return this;
    }

    public NotifyOrder2JSONRequest withTid(String tid) {
        this.tid = tid;
        return this;
    }

    public NotifyOrder2JSONRequest withConsumeQty(Float consumeQty) {
        this.consumeQty = consumeQty.toString();
        return this;
    }

    public NotifyOrder2JSONRequest withConsumeQty(String consumeQty) {
        this.consumeQty = consumeQty;
        return this;
    }

    public NotifyOrder2JSONRequest withConsumeAmount(String consumeAmount) {
        this.consumeAmount = consumeAmount;
        return this;
    }

    public NotifyOrder2JSONRequest withConsumeAmount(Float consumeAmount) {
        this.consumeAmount = consumeAmount.toString();
        return this;
    }

    public NotifyOrder2JSONRequest withProductCurrency(String productCurrency) {
        this.productCurrency = productCurrency;
        return this;
    }

    public NotifyOrder2JSONRequest withConsumeCurrency(String consumeCurrency) {
        this.consumeCurrency = consumeCurrency;
        return this;
    }

    public NotifyOrder2JSONRequest withCertificate(Integer certificate) {
        this.certificate = certificate;
        return this;
    }

    public NotifyOrder2JSONRequest withConsumeMoneyQty(String consumeMoneyQty) {
        this.consumeMoneyQty = consumeMoneyQty;
        return this;
    }

    public NotifyOrder2JSONRequest withConsumeMoneyQty(Float consumeMoneyQty) {
        this.consumeMoneyQty = consumeMoneyQty.toString();
        return this;
    }

    public NotifyOrder2JSONRequest withCompletionFixedMoneyQty(String completionFixedMoneyQty) {
        this.completionFixedMoneyQty = completionFixedMoneyQty;
        return this;
    }

    public NotifyOrder2JSONRequest withCompletionFixedMoneyQty(Float completionFixedMoneyQty) {
        this.completionFixedMoneyQty = completionFixedMoneyQty.toString();
        return this;
    }

    public NotifyOrder2JSONRequest withCompletionFixedQty(String completionFixedQty) {
        this.completionFixedQty = completionFixedQty;
        return this;
    }

    public NotifyOrder2JSONRequest withCompletionFixedQty(Float completionFixedQty) {
        this.completionFixedQty = completionFixedQty.toString();
        return this;
    }

    public NotifyOrder2JSONRequest withTotalConsumeQty(String totalConsumeQty) {
        this.totalConsumeQty = totalConsumeQty;
        return this;
    }

    public NotifyOrder2JSONRequest withTotalConsumeQty(Float totalConsumeQty) {
        this.totalConsumeQty = totalConsumeQty.toString();
        return this;
    }

    public NotifyOrder2JSONRequest withTimestamp() {
        SimpleDateFormat timestampDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return this.withTid(timestampDateFormat.format(DateTime.now().toDate()));
    }
}

