package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bannerland;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Created by ssdmitriev on 02.12.15.
 */
public enum GenerateStatus {
    NON_EMPTY("non-empty"),
    EMPTY("empty");

    private String name;

    GenerateStatus(String name) {
        this.name = name;
    }

    public String toString() {
        return name;
    }

    @JsonValue
    public String value() {
        return name;
    }

    @JsonCreator
    public static GenerateStatus getStatusByName(String name) {
        for (GenerateStatus value : GenerateStatus.values()) {
            if (value.name.equals(name)) {
                return value;
            }
        }
        throw new IllegalArgumentException("Статус " + name + " не найден");
    }
}
