package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bannersearch;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.List;
import java.util.Map;

/**
 * Created by semkagtn on 12/3/14.
 */
public class BannerSearchRequestData {
    @JsonProperty("criteria")
    public List<Criteria> criteria;

    @JsonProperty("media")
    private Integer media;

    @JsonProperty("limit")
    private Integer limit;

    @JsonProperty("offset")
    private Integer offset;

    @JsonProperty("short")
    private Integer shortResponse;

    @JsonProperty("activeonly")
    private Integer activeonly;

    @JsonProperty("include_currency_archived_campaigns")
    private Integer includeCurrencyArchivedCampaigns;

    @JsonProperty("group_camp")
    private Integer groupCamp;

    @JsonProperty("strict_phrase")
    private Integer strictPhrase;

    @JsonProperty("exact_domain")
    private Integer exactDomain;

    public BannerSearchRequestData withCriteria(List<Criteria> criteria) {
        this.criteria = criteria;
        return this;
    }

    public BannerSearchRequestData withMedia(Integer media) {
        this.media = media;
        return this;
    }

    public BannerSearchRequestData withActiveonly(Integer activeonly) {
        this.activeonly = activeonly;
        return this;
    }

    public BannerSearchRequestData withIncludeCurrencyArchivedCampaigns(Integer includeCurrencyArchivedCampaigns) {
        this.includeCurrencyArchivedCampaigns = includeCurrencyArchivedCampaigns;
        return this;
    }

    public BannerSearchRequestData withGroupCamp(Integer groupCamp) {
        this.groupCamp = groupCamp;
        return this;
    }

    public BannerSearchRequestData withStrictPhrase(Integer strictPhrase) {
        this.strictPhrase = strictPhrase;
        return this;
    }

    public BannerSearchRequestData withExactDomain(Integer exactDomain) {
        this.exactDomain = exactDomain;
        return this;
    }

    public BannerSearchRequestData withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public BannerSearchRequestData withOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public BannerSearchRequestData withShortResponse(Integer shortResponse) {
        this.shortResponse = shortResponse;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
