package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bannersearch;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by semkagtn on 12/3/14.
 */
public class BannerSearchResponseData {

    @JsonProperty("banners")
    private List<Banner> banners;

    public List<Banner> getBanners() {
        return banners;
    }

    public void setBanners(List<Banner> banners) {
        this.banners = banners;
    }

    public BannerSearchResponseData withBanners(List<Banner> banners) {
        this.banners = banners;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)    //DIRECT-59264
    public static class Banner {

        @JsonProperty("sitelinks")
        private List<SiteLink> sitelinks;

        @JsonProperty("callouts")
        private List<Callout> callouts;

        @JsonProperty("bs_info")
        private BsInfo bsInfo;

        @JsonProperty("sum_spent")
        private BigDecimal sumSpent;

        @JsonProperty("day_budget_stop_time")
        private String dayBudgetStopTime;

        @JsonProperty("user_phone")
        private String userPhone;

        @JsonProperty("sum")
        private BigDecimal sum;

        @JsonProperty("metro")
        private String metro;

        @JsonProperty("day_budget_daily_change_count")
        private String dayBudgetDailyChangeCount;

        @JsonProperty("timeTarget")
        private String timeTarget;

        @JsonProperty("geo")
        private String geo;

        @JsonProperty("uid")
        private Long uid;

        @JsonProperty("start_time")
        private String startTime;

        @JsonProperty("name")
        private String name;

        @JsonProperty("memail")
        private String memail;

        @JsonProperty("mfio")
        private String mfio;

        @JsonProperty("timezone_id")
        private Short timeZoneId;

        @JsonProperty("login")
        private String login;

        @JsonProperty("mlogin")
        private String mlogin;

        @JsonProperty("statusBsSynced")
        private String statusBySynced;

        @JsonProperty("wallet_cid")
        private Long walletCid;

        @JsonProperty("day_budget")
        private BigDecimal dayBudget;

        @JsonProperty("cid")
        private Long cid;

        @JsonProperty("title")
        private String title;

        @JsonProperty("title_extension")
        private String titleExtension;
        @JsonProperty("turbolanding_id")
        private Long turbolandingId;
        @JsonProperty("turbolanding")
        private Turbolanding turbolanding;
        @JsonProperty("apart")
        private String apart;
        @JsonProperty("aemail")
        private String aemail;
        @JsonProperty("worktime")
        private String workTime;
        @JsonProperty("currency")
        private String currency;
        @JsonProperty("body")
        private String body;
        @JsonProperty("domain")
        private String domain;
        @JsonProperty("image_id")
        private Long imageId;
        @JsonProperty("image")
        private String image;
        @JsonProperty("image_name")
        private String imageName;
        @JsonProperty("image_BannerID")
        private Long imageBannerId;
        @JsonProperty("image_PriorityID")
        private Integer imagePriorityId;
        @JsonProperty("image_statusModerate")
        private String imageStatusModerate;
        @JsonProperty("day_budget_show_mode")
        private String dayBudgetShowMode;
        @JsonProperty("house")
        private String house;
        @JsonProperty("country")
        private String country;
        @JsonProperty("camp_name")
        private String campName;
        @JsonProperty("FIO")
        private String fio;
        @JsonProperty("build")
        private String build;
        @JsonProperty("extra_message")
        private String extraMessage;
        @JsonProperty("alogin")
        private String alogin;
        @JsonProperty("ManagerUID")
        private Long managerUid;
        @JsonProperty("contact_email")
        private String contactEmail;
        @JsonProperty("im_login")
        private String imLogin;
        @JsonProperty("org_details_id")
        private Long orgDetailsId;
        @JsonProperty("bid")
        private Long bid;
        @JsonProperty("street")
        private String street;
        @JsonProperty("statusShow")
        private String statusShow;
        @JsonProperty("sum_to_pay")
        private BigDecimal sumToPay;
        @JsonProperty("href")
        private String href;
        @JsonProperty("im_client")
        private String imClient;
        @JsonProperty("statusModerate")
        private String statusModerate;
        @JsonProperty("contactperson")
        private String contactPerson;
        @JsonProperty("wallet_sum_spent")
        private BigDecimal walletSumSpent;
        @JsonProperty("statusActive")
        private String statusActive;
        @JsonProperty("archived")
        private String archived;
        @JsonProperty("yacontextCategories")
        private String yaContextCategories;
        @JsonProperty("stopTime")
        private String stopTime;
        @JsonProperty("type")
        private String type;
        @JsonProperty("AgencyUID")
        private Long agencyUid;
        @JsonProperty("finish_time")
        private String finishTime;
        @JsonProperty("OrderID")
        private Long orderId;
        @JsonProperty("city")
        private String city;
        @JsonProperty("wallet_sum")
        private BigDecimal walletSum;
        @JsonProperty("flags")
        private String flags;
        @JsonProperty("phone")
        private String phone;
        @JsonProperty("statusPostModerate")
        private String statusPostModerate;
        @JsonProperty("afio")
        private String afio;
        @JsonProperty("currencyConverted")
        private String currencyConverted;
        @JsonProperty("delayed_arc")
        private String delayedArc;
        @JsonProperty("name_flash")
        private String nameFlash;
        @JsonProperty("name_picture")
        private String namePicture;
        @JsonProperty("md5_picture")
        private String md5Picture;
        @JsonProperty("format_id")
        private Integer formatId;
        @JsonProperty("md5_flash")
        private String md5Flash;
        @JsonProperty("mgid")
        private Integer mgid;
        @JsonProperty("alt")
        private String alt;
        @JsonProperty("vcard_id")
        private Long vcardId;
        @JsonProperty("dontShowYacontext")
        private String dontShowYacontext;
        @JsonProperty("numword")
        private Integer numWord;
        @JsonProperty("phoneflag")
        private String phoneFlag;
        @JsonProperty("price")
        private BigDecimal price;
        @JsonProperty("ClientID")
        private Long clientID;
        @JsonProperty("BannerID")
        private Long bannerID;
        @JsonProperty("PhraseID")
        private Long phraseID;
        @JsonProperty("spent_today")
        private String spentToday;
        @JsonProperty("adgroup_type")
        private String adgroupType;
        @JsonProperty("primary_action")
        private String primaryAction;
        @JsonProperty("pid")
        private Long pid;
        @JsonProperty("device_type_targeting")
        private String deviceTypeTargeting;
        @JsonProperty("mobile_content_id")
        private String mobileContentId;
        @JsonProperty("network_targeting")
        private String networkTargeting;
        @JsonProperty("reflected_attrs")
        private List<String> reflectedAttrs;
        @JsonProperty("mediaType")
        private String mediaType;
        @JsonProperty("store_content_href")
        private String storeContentHref;
        @JsonProperty("creative_preview_url")
        private String creativePreviewUrl;
        @JsonProperty("creative_name")
        private String creativeName;
        @JsonProperty("sitelinks_set_id")
        private Long siteLinksSetId;
        @JsonProperty("ad_type")
        private String adType;
        @JsonProperty("image_ad")
        private ImageAd imageAd;

        public Turbolanding getTurbolanding() {
            return turbolanding;
        }

        public void setTurbolanding(Turbolanding turbolanding) {
            this.turbolanding = turbolanding;
        }

        public Banner withTurbolanding(Turbolanding turbolanding) {
            this.turbolanding = turbolanding;
            return this;
        }

        public Long getTurbolandingId() {
            return turbolandingId;
        }

        public void setTurbolandingId(Long turbolandingId) {
            this.turbolandingId = turbolandingId;
        }

        public Banner withTurbolandingId(Long turbolandingId) {
            this.turbolandingId = turbolandingId;
            return this;
        }

        public List<SiteLink> getSitelinks() {
            return sitelinks;
        }

        public void setSitelinks(List<SiteLink> sitelinks) {
            this.sitelinks = sitelinks;
        }

        public Banner withSitelinks(List<SiteLink> sitelinks) {
            this.sitelinks = sitelinks;
            return this;
        }

        public List<Callout> getCallouts() {
            return callouts;
        }

        public void setCallouts(List<Callout> callouts) {
            this.callouts = callouts;
        }

        public Banner withCallouts(List<Callout> callouts) {
            this.callouts = callouts;
            return this;
        }

        public BsInfo getBsInfo() {
            return bsInfo;
        }

        public void setBsInfo(BsInfo bsInfo) {
            this.bsInfo = bsInfo;
        }

        public Banner withBsInfo(BsInfo bsInfo) {
            this.bsInfo = bsInfo;
            return this;
        }

        public BigDecimal getSumSpent() {
            return sumSpent;
        }

        public void setSumSpent(BigDecimal sumSpent) {
            this.sumSpent = sumSpent;
        }

        public Banner withSumSpent(BigDecimal sumSpent) {
            this.sumSpent = sumSpent;
            return this;
        }

        public String getDayBudgetStopTime() {
            return dayBudgetStopTime;
        }

        public void setDayBudgetStopTime(String dayBudgetStopTime) {
            this.dayBudgetStopTime = dayBudgetStopTime;
        }

        public Banner withDayBudgetStopTime(String dayBudgetStopTime) {
            this.dayBudgetStopTime = dayBudgetStopTime;
            return this;
        }

        public String getUserPhone() {
            return userPhone;
        }

        public void setUserPhone(String userPhone) {
            this.userPhone = userPhone;
        }

        public Banner withUserPhone(String userPhone) {
            this.userPhone = userPhone;
            return this;
        }

        public BigDecimal getSum() {
            return sum;
        }

        public void setSum(BigDecimal sum) {
            this.sum = sum;
        }

        public Banner withSum(BigDecimal sum) {
            this.sum = sum;
            return this;
        }

        public String getMetro() {
            return metro;
        }

        public void setMetro(String metro) {
            this.metro = metro;
        }

        public Banner withMetro(String metro) {
            this.metro = metro;
            return this;
        }

        public String getDayBudgetDailyChangeCount() {
            return dayBudgetDailyChangeCount;
        }

        public void setDayBudgetDailyChangeCount(String dayBudgetDailyChangeCount) {
            this.dayBudgetDailyChangeCount = dayBudgetDailyChangeCount;
        }

        public Banner withDayBudgetDailyChangeCount(String dayBudgetDailyChangeCount) {
            this.dayBudgetDailyChangeCount = dayBudgetDailyChangeCount;
            return this;
        }

        public String getTimeTarget() {
            return timeTarget;
        }

        public void setTimeTarget(String timeTarget) {
            this.timeTarget = timeTarget;
        }

        public Banner withTimeTarget(String timeTarget) {
            this.timeTarget = timeTarget;
            return this;
        }

        public String getGeo() {
            return geo;
        }

        public void setGeo(String geo) {
            this.geo = geo;
        }

        public Banner withGeo(String geo) {
            this.geo = geo;
            return this;
        }

        public Long getUid() {
            return uid;
        }

        public void setUid(Long uid) {
            this.uid = uid;
        }

        public Banner withUid(Long uid) {
            this.uid = uid;
            return this;
        }

        public String getStartTime() {
            return startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public Banner withStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Banner withName(String name) {
            this.name = name;
            return this;
        }

        public String getMemail() {
            return memail;
        }

        public void setMemail(String memail) {
            this.memail = memail;
        }

        public Banner withMemail(String memail) {
            this.memail = memail;
            return this;
        }

        public String getMfio() {
            return mfio;
        }

        public void setMfio(String mfio) {
            this.mfio = mfio;
        }

        public Banner withMfio(String mfio) {
            this.mfio = mfio;
            return this;
        }

        public Short getTimeZoneId() {
            return timeZoneId;
        }

        public void setTimeZoneId(Short timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        public Banner withTimeZoneId(Short timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public String getLogin() {
            return login;
        }

        public void setLogin(String login) {
            this.login = login;
        }

        public Banner withLogin(String login) {
            this.login = login;
            return this;
        }

        public String getMlogin() {
            return mlogin;
        }

        public void setMlogin(String mlogin) {
            this.mlogin = mlogin;
        }

        public Banner withMlogin(String mlogin) {
            this.mlogin = mlogin;
            return this;
        }

        public String getStatusBySynced() {
            return statusBySynced;
        }

        public void setStatusBySynced(String statusBySynced) {
            this.statusBySynced = statusBySynced;
        }

        public Banner withStatusBySynced(String statusBySynced) {
            this.statusBySynced = statusBySynced;
            return this;
        }

        public Long getWalletCid() {
            return walletCid;
        }

        public void setWalletCid(Long walletCid) {
            this.walletCid = walletCid;
        }

        public Banner withWalletCid(Long walletCid) {
            this.walletCid = walletCid;
            return this;
        }

        public BigDecimal getDayBudget() {
            return dayBudget;
        }

        public void setDayBudget(BigDecimal dayBudget) {
            this.dayBudget = dayBudget;
        }

        public Banner withDayBudget(BigDecimal dayBudget) {
            this.dayBudget = dayBudget;
            return this;
        }

        public Long getCid() {
            return cid;
        }

        public void setCid(Long cid) {
            this.cid = cid;
        }

        public Banner withCid(Long cid) {
            this.cid = cid;
            return this;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Banner withTitle(String title) {
            this.title = title;
            return this;
        }

        public String getTitleExtension() {
            return titleExtension;
        }

        public void setTitleExtension(String titleExtension) {
            this.titleExtension = titleExtension;
        }

        public Banner withTitleExtension(String titleExtension) {
            this.titleExtension = titleExtension;
            return this;
        }

        public String getApart() {
            return apart;
        }

        public void setApart(String apart) {
            this.apart = apart;
        }

        public Banner withApart(String apart) {
            this.apart = apart;
            return this;
        }

        public String getAemail() {
            return aemail;
        }

        public void setAemail(String aemail) {
            this.aemail = aemail;
        }

        public Banner withAemail(String aemail) {
            this.aemail = aemail;
            return this;
        }

        public String getWorkTime() {
            return workTime;
        }

        public void setWorkTime(String workTime) {
            this.workTime = workTime;
        }

        public Banner withWorkTime(String workTime) {
            this.workTime = workTime;
            return this;
        }

        public String getCurrency() {
            return currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public Banner withCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public String getBody() {
            return body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Banner withBody(String body) {
            this.body = body;
            return this;
        }

        public String getDomain() {
            return domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public Banner withDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Long getImageId() {
            return imageId;
        }

        public void setImageId(Long imageId) {
            this.imageId = imageId;
        }

        public Banner withImageId(Long imageId) {
            this.imageId = imageId;
            return this;
        }

        public String getImage() {
            return image;
        }

        public void setImage(String image) {
            this.image = image;
        }

        public Banner withImage(String image) {
            this.image = image;
            return this;
        }

        public String getImageName() {
            return imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public Banner withImageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public Long getImageBannerId() {
            return imageBannerId;
        }

        public void setImageBannerId(Long imageBannerId) {
            this.imageBannerId = imageBannerId;
        }

        public Banner withImageBannerId(Long imageBannerId) {
            this.imageBannerId = imageBannerId;
            return this;
        }

        public Integer getImagePriorityId() {
            return imagePriorityId;
        }

        public void setImagePriorityId(Integer imagePriorityId) {
            this.imagePriorityId = imagePriorityId;
        }

        public Banner withImagePriorityId(Integer imagePriorityId) {
            this.imagePriorityId = imagePriorityId;
            return this;
        }

        public String getImageStatusModerate() {
            return imageStatusModerate;
        }

        public void setImageStatusModerate(String imageStatusModerate) {
            this.imageStatusModerate = imageStatusModerate;
        }

        public Banner withImageStatusModerate(String imageStatusModerate) {
            this.imageStatusModerate = imageStatusModerate;
            return this;
        }

        public String getDayBudgetShowMode() {
            return dayBudgetShowMode;
        }

        public void setDayBudgetShowMode(String dayBudgetShowMode) {
            this.dayBudgetShowMode = dayBudgetShowMode;
        }

        public Banner withDayBudgetShowMode(String dayBudgetShowMode) {
            this.dayBudgetShowMode = dayBudgetShowMode;
            return this;
        }

        public String getHouse() {
            return house;
        }

        public void setHouse(String house) {
            this.house = house;
        }

        public Banner withHouse(String house) {
            this.house = house;
            return this;
        }

        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public Banner withCountry(String country) {
            this.country = country;
            return this;
        }

        public String getCampName() {
            return campName;
        }

        public void setCampName(String campName) {
            this.campName = campName;
        }

        public Banner withCampName(String campName) {
            this.campName = campName;
            return this;
        }

        public String getFio() {
            return fio;
        }

        public void setFio(String fio) {
            this.fio = fio;
        }

        public Banner withFio(String fio) {
            this.fio = fio;
            return this;
        }

        public String getBuild() {
            return build;
        }

        public void setBuild(String build) {
            this.build = build;
        }

        public Banner withBuild(String build) {
            this.build = build;
            return this;
        }

        public String getExtraMessage() {
            return extraMessage;
        }

        public void setExtraMessage(String extraMessage) {
            this.extraMessage = extraMessage;
        }

        public Banner withExtraMessage(String extraMessage) {
            this.extraMessage = extraMessage;
            return this;
        }

        public String getAlogin() {
            return alogin;
        }

        public void setAlogin(String alogin) {
            this.alogin = alogin;
        }

        public Banner withAlogin(String alogin) {
            this.alogin = alogin;
            return this;
        }

        public Long getManagerUid() {
            return managerUid;
        }

        public void setManagerUid(Long managerUid) {
            this.managerUid = managerUid;
        }

        public Banner withManagerUid(Long managerUid) {
            this.managerUid = managerUid;
            return this;
        }

        public String getContactEmail() {
            return contactEmail;
        }

        public void setContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
        }

        public Banner withContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
            return this;
        }

        public String getImLogin() {
            return imLogin;
        }

        public void setImLogin(String imLogin) {
            this.imLogin = imLogin;
        }

        public Banner withImLogin(String imLogin) {
            this.imLogin = imLogin;
            return this;
        }

        public Long getOrgDetailsId() {
            return orgDetailsId;
        }

        public void setOrgDetailsId(Long orgDetailsId) {
            this.orgDetailsId = orgDetailsId;
        }

        public Banner withOrgDetailsId(Long orgDetailsId) {
            this.orgDetailsId = orgDetailsId;
            return this;
        }

        public Long getBid() {
            return bid;
        }

        public void setBid(Long bid) {
            this.bid = bid;
        }

        public Banner withBid(Long bid) {
            this.bid = bid;
            return this;
        }

        public String getStreet() {
            return street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public Banner withStreet(String street) {
            this.street = street;
            return this;
        }

        public String getStatusShow() {
            return statusShow;
        }

        public void setStatusShow(String statusShow) {
            this.statusShow = statusShow;
        }

        public Banner withStatusShow(String statusShow) {
            this.statusShow = statusShow;
            return this;
        }

        public BigDecimal getSumToPay() {
            return sumToPay;
        }

        public void setSumToPay(BigDecimal sumToPay) {
            this.sumToPay = sumToPay;
        }

        public Banner withSumToPay(BigDecimal sumToPay) {
            this.sumToPay = sumToPay;
            return this;
        }

        public String getHref() {
            return href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public Banner withHref(String href) {
            this.href = href;
            return this;
        }

        public String getImClient() {
            return imClient;
        }

        public void setImClient(String imClient) {
            this.imClient = imClient;
        }

        public Banner withImClient(String imClient) {
            this.imClient = imClient;
            return this;
        }

        public String getStatusModerate() {
            return statusModerate;
        }

        public void setStatusModerate(String statusModerate) {
            this.statusModerate = statusModerate;
        }

        public Banner withStatusModerate(String statusModerate) {
            this.statusModerate = statusModerate;
            return this;
        }

        public String getContactPerson() {
            return contactPerson;
        }

        public void setContactPerson(String contactPerson) {
            this.contactPerson = contactPerson;
        }

        public Banner withContactPerson(String contactPerson) {
            this.contactPerson = contactPerson;
            return this;
        }

        public BigDecimal getWalletSumSpent() {
            return walletSumSpent;
        }

        public void setWalletSumSpent(BigDecimal walletSumSpent) {
            this.walletSumSpent = walletSumSpent;
        }

        public Banner withWalletSumSpent(BigDecimal walletSumSpent) {
            this.walletSumSpent = walletSumSpent;
            return this;
        }

        public String getStatusActive() {
            return statusActive;
        }

        public void setStatusActive(String statusActive) {
            this.statusActive = statusActive;
        }

        public Banner withStatusActive(String statusActive) {
            this.statusActive = statusActive;
            return this;
        }

        public String getArchived() {
            return archived;
        }

        public void setArchived(String archived) {
            this.archived = archived;
        }

        public Banner withArchived(String archived) {
            this.archived = archived;
            return this;
        }

        public String getYaContextCategories() {
            return yaContextCategories;
        }

        public void setYaContextCategories(String yaContextCategories) {
            this.yaContextCategories = yaContextCategories;
        }

        public Banner withYaContextCategories(String yaContextCategories) {
            this.yaContextCategories = yaContextCategories;
            return this;
        }

        public String getStopTime() {
            return stopTime;
        }

        public void setStopTime(String stopTime) {
            this.stopTime = stopTime;
        }

        public Banner withStopTime(String stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Banner withType(String type) {
            this.type = type;
            return this;
        }

        public Long getAgencyUid() {
            return agencyUid;
        }

        public void setAgencyUid(Long agencyUid) {
            this.agencyUid = agencyUid;
        }

        public Banner withAgencyUid(Long agencyUid) {
            this.agencyUid = agencyUid;
            return this;
        }

        public String getFinishTime() {
            return finishTime;
        }

        public void setFinishTime(String finishTime) {
            this.finishTime = finishTime;
        }

        public Banner withFinishTime(String finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public Long getOrderId() {
            return orderId;
        }

        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        public Banner withOrderId(Long orderId) {
            this.orderId = orderId;
            return this;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public Banner withCity(String city) {
            this.city = city;
            return this;
        }

        public BigDecimal getWalletSum() {
            return walletSum;
        }

        public void setWalletSum(BigDecimal walletSum) {
            this.walletSum = walletSum;
        }

        public Banner withWalletSum(BigDecimal walletSum) {
            this.walletSum = walletSum;
            return this;
        }

        public String getFlags() {
            return flags;
        }

        public void setFlags(String flags) {
            this.flags = flags;
        }

        public Banner withFlags(String flags) {
            this.flags = flags;
            return this;
        }

        public String getPhone() {
            return phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public Banner withPhone(String phone) {
            this.phone = phone;
            return this;
        }

        public String getStatusPostModerate() {
            return statusPostModerate;
        }

        public void setStatusPostModerate(String statusPostModerate) {
            this.statusPostModerate = statusPostModerate;
        }

        public Banner withStatusPostModerate(String statusPostModerate) {
            this.statusPostModerate = statusPostModerate;
            return this;
        }

        public String getAfio() {
            return afio;
        }

        public void setAfio(String afio) {
            this.afio = afio;
        }

        public Banner withAfio(String afio) {
            this.afio = afio;
            return this;
        }

        public String getCurrencyConverted() {
            return currencyConverted;
        }

        public void setCurrencyConverted(String currencyConverted) {
            this.currencyConverted = currencyConverted;
        }

        public Banner withCurrencyConverted(String currencyConverted) {
            this.currencyConverted = currencyConverted;
            return this;
        }

        public String getDelayedArc() {
            return delayedArc;
        }

        public void setDelayedArc(String delayedArc) {
            this.delayedArc = delayedArc;
        }

        public Banner withDelayedArc(String delayedArc) {
            this.delayedArc = delayedArc;
            return this;
        }

        public String getNameFlash() {
            return nameFlash;
        }

        public void setNameFlash(String nameFlash) {
            this.nameFlash = nameFlash;
        }

        public Banner withNameFlash(String nameFlash) {
            this.nameFlash = nameFlash;
            return this;
        }

        public String getNamePicture() {
            return namePicture;
        }

        public void setNamePicture(String namePicture) {
            this.namePicture = namePicture;
        }

        public Banner withNamePicture(String namePicture) {
            this.namePicture = namePicture;
            return this;
        }

        public String getMd5Picture() {
            return md5Picture;
        }

        public void setMd5Picture(String md5Picture) {
            this.md5Picture = md5Picture;
        }

        public Banner withMd5Picture(String md5Picture) {
            this.md5Picture = md5Picture;
            return this;
        }

        public Integer getFormatId() {
            return formatId;
        }

        public void setFormatId(Integer formatId) {
            this.formatId = formatId;
        }

        public Banner withFormatId(Integer formatId) {
            this.formatId = formatId;
            return this;
        }

        public String getMd5Flash() {
            return md5Flash;
        }

        public void setMd5Flash(String md5Flash) {
            this.md5Flash = md5Flash;
        }

        public Banner withMd5Flash(String md5Flash) {
            this.md5Flash = md5Flash;
            return this;
        }

        public Integer getMgid() {
            return mgid;
        }

        public void setMgid(Integer mgid) {
            this.mgid = mgid;
        }

        public Banner withMgid(Integer mgid) {
            this.mgid = mgid;
            return this;
        }

        public String getAlt() {
            return alt;
        }

        public void setAlt(String alt) {
            this.alt = alt;
        }

        public Banner withAlt(String alt) {
            this.alt = alt;
            return this;
        }

        public Long getVcardId() {
            return vcardId;
        }

        public void setVcardId(Long vcardId) {
            this.vcardId = vcardId;
        }

        public Banner withVcardId(Long vcardId) {
            this.vcardId = vcardId;
            return this;
        }

        public String getDontShowYacontext() {
            return dontShowYacontext;
        }

        public void setDontShowYacontext(String dontShowYacontext) {
            this.dontShowYacontext = dontShowYacontext;
        }

        public Banner withDontShowYacontext(String dontShowYacontext) {
            this.dontShowYacontext = dontShowYacontext;
            return this;
        }

        public Integer getNumWord() {
            return numWord;
        }

        public void setNumWord(Integer numWord) {
            this.numWord = numWord;
        }

        public Banner withNumWord(Integer numWord) {
            this.numWord = numWord;
            return this;
        }

        public String getPhoneFlag() {
            return phoneFlag;
        }

        public void setPhoneFlag(String phoneFlag) {
            this.phoneFlag = phoneFlag;
        }

        public Banner withPhoneFlag(String phoneFlag) {
            this.phoneFlag = phoneFlag;
            return this;
        }

        public BigDecimal getPrice() {
            return price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public Banner withPrice(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Long getClientID() {
            return clientID;
        }

        public void setClientID(Long clientID) {
            this.clientID = clientID;
        }

        public Banner withClientID(Long clientID) {
            this.clientID = clientID;
            return this;
        }

        public Long getBannerID() {
            return bannerID;
        }

        public void setBannerID(Long bannerID) {
            this.bannerID = bannerID;
        }

        public Banner withBannerID(Long bannerID) {
            this.bannerID = bannerID;
            return this;
        }

        public Long getPhraseID() {
            return phraseID;
        }

        public void setPhraseID(Long phraseID) {
            this.phraseID = phraseID;
        }

        public Banner withPhraseID(Long phraseID) {
            this.phraseID = phraseID;
            return this;
        }

        public String getSpentToday() {
            return spentToday;
        }

        public void setSpentToday(String spentToday) {
            this.spentToday = spentToday;
        }

        public Banner withSpentToday(String spentToday) {
            this.spentToday = spentToday;
            return this;
        }

        public String getAdgroupType() {
            return adgroupType;
        }

        public void setAdgroupType(String adgroupType) {
            this.adgroupType = adgroupType;
        }

        public Banner withAdgroupType(String adgroupType) {
            this.adgroupType = adgroupType;
            return this;
        }

        public String getPrimaryAction() {
            return primaryAction;
        }

        public void setPrimaryAction(String primaryAction) {
            this.primaryAction = primaryAction;
        }

        public Banner withPrimaryAction(String primaryAction) {
            this.primaryAction = primaryAction;
            return this;
        }

        public Long getPid() {
            return pid;
        }

        public void setPid(Long pid) {
            this.pid = pid;
        }

        public Banner withPid(Long pid) {
            this.pid = pid;
            return this;
        }

        public String getDeviceTypeTargeting() {
            return deviceTypeTargeting;
        }

        public void setDeviceTypeTargeting(String deviceTypeTargeting) {
            this.deviceTypeTargeting = deviceTypeTargeting;
        }

        public Banner withDeviceTypeTargeting(String deviceTypeTargeting) {
            this.deviceTypeTargeting = deviceTypeTargeting;
            return this;
        }

        public String getMobileContentId() {
            return mobileContentId;
        }

        public void setMobileContentId(String mobileContentId) {
            this.mobileContentId = mobileContentId;
        }

        public Banner withMobileContentId(String mobileContentId) {
            this.mobileContentId = mobileContentId;
            return this;
        }

        public String getNetworkTargeting() {
            return networkTargeting;
        }

        public void setNetworkTargeting(String networkTargeting) {
            this.networkTargeting = networkTargeting;
        }

        public Banner withNetworkTargeting(String networkTargeting) {
            this.networkTargeting = networkTargeting;
            return this;
        }

        public List<String> getReflectedAttrs() {
            return reflectedAttrs;
        }

        public void setReflectedAttrs(List<String> reflectedAttrs) {
            this.reflectedAttrs = reflectedAttrs;
        }

        public Banner withReflectedAttrs(List<String> reflectedAttrs) {
            this.reflectedAttrs = reflectedAttrs;
            return this;
        }

        public String getMediaType() {
            return mediaType;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public Banner withMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public String getStoreContentHref() {
            return storeContentHref;
        }

        public void setStoreContentHref(String storeContentHref) {
            this.storeContentHref = storeContentHref;
        }

        public Banner withStoreContentHref(String storeContentHref) {
            this.storeContentHref = storeContentHref;
            return this;
        }

        public String getCreativePreviewUrl() {
            return creativePreviewUrl;
        }

        public void setCreativePreviewUrl(String creativePreviewUrl) {
            this.creativePreviewUrl = creativePreviewUrl;
        }

        public Banner withCreativePreviewUrl(String creativePreviewUrl) {
            this.creativePreviewUrl = creativePreviewUrl;
            return this;
        }

        public String getCreativeName() {
            return creativeName;
        }

        public void setCreativeName(String creativeName) {
            this.creativeName = creativeName;
        }

        public Banner withCreativeName(String creativeName) {
            this.creativeName = creativeName;
            return this;
        }

        public Long getSiteLinksSetId() {
            return siteLinksSetId;
        }

        public void setSiteLinksSetId(Long siteLinksSetId) {
            this.siteLinksSetId = siteLinksSetId;
        }

        public Banner withSiteLinksSetId(Long siteLinksSetId) {
            this.siteLinksSetId = siteLinksSetId;
            return this;
        }

        public String getAdType() {
            return adType;
        }

        public void setAdType(String adType) {
            this.adType = adType;
        }

        public Banner withAdType(String adType) {
            this.adType = adType;
            return this;
        }

        public ImageAd getImageAd() {
            return imageAd;
        }

        public void setImageAd(ImageAd imageAd) {
            this.imageAd = imageAd;
        }

        public Banner withImageAd(ImageAd imageAd) {
            this.imageAd = imageAd;
            return this;
        }

        @Override
        public String toString() {
            return JsonUtils.toString(this);
        }

        public static class ImageAd {
            @JsonProperty("width")
            private Short width;

            @JsonProperty("height")
            private Short height;

            @JsonProperty("group_id")
            private Long groupId;

            @JsonProperty("name")
            private String name;

            @JsonProperty("scale")
            private String scale;

            @JsonProperty("hash")
            private String hash;

            public String getHash() {
                return hash;
            }

            public void withHash(String hash) {
                this.hash = hash;
            }

            public Short getWidth() {
                return width;
            }

            public void withWidth(Short width) {
                this.width = width;
            }

            public Short getHeight() {
                return height;
            }

            public void withHeight(Short height) {
                this.height = height;
            }

            public Long getGroupId() {
                return groupId;
            }

            public void withGroupId(Long groupId) {
                this.groupId = groupId;
            }

            public String getName() {
                return name;
            }

            public void withName(String name) {
                this.name = name;
            }

            public String getScale() {
                return scale;
            }

            public void withScale(String scale) {
                this.scale = scale;
            }


            @Override
            public String toString() {
                return JsonUtils.toString(this);
            }
        }

        public static class SiteLink {

            @JsonProperty("title")
            private String title;

            @JsonProperty("sl_id")
            private Long slId;

            @JsonProperty("hash")
            private String hash;

            @JsonProperty("href")
            private String href;

            @JsonProperty("description")
            private String description;
            @JsonProperty("turbolanding")
            private Turbolanding turbolanding;

            public Turbolanding getTurbolanding() {
                return turbolanding;
            }

            public void setTurbolanding(Turbolanding turbolanding) {
                this.turbolanding = turbolanding;
            }

            SiteLink withTurbolanding(Turbolanding turbolanding) {
                this.turbolanding = turbolanding;
                return this;
            }

            public String getTitle() {
                return title;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public SiteLink withTitle(String title) {
                this.title = title;
                return this;
            }

            public Long getSlId() {
                return slId;
            }

            public void setSlId(Long slId) {
                this.slId = slId;
            }

            public SiteLink withSlId(Long slId) {
                this.slId = slId;
                return this;
            }

            public String getHash() {
                return hash;
            }

            public void setHash(String hash) {
                this.hash = hash;
            }

            public SiteLink withHash(String hash) {
                this.hash = hash;
                return this;
            }

            public String getHref() {
                return href;
            }

            public void setHref(String href) {
                this.href = href;
            }

            public SiteLink withHref(String href) {
                this.href = href;
                return this;
            }

            public String getDescription() {
                return description;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public SiteLink withDescription(String description) {
                this.description = description;
                return this;
            }

            @Override
            public String toString() {
                return JsonUtils.toString(this);
            }

        }

        public static class Turbolanding {
            @JsonProperty("href")
            private String href;
            @JsonProperty("id")
            private Long id;
            @JsonProperty("name")
            private String name;

            public String getHref() {
                return href;
            }

            public void setHref(String href) {
                this.href = href;
            }

            public Long getId() {
                return id;
            }

            public void setId(Long id) {
                this.id = id;
            }

            public String getName() {
                return name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public Turbolanding withHref(String href) {
                this.href = href;
                return this;
            }

            public Turbolanding withId(Long id) {
                this.id = id;
                return this;
            }

            public Turbolanding withName(String name) {
                this.name = name;
                return this;
            }
        }

        public static class Callout {

            @JsonProperty("callout_text")
            private String calloutText;

            @JsonProperty("status_moderate")
            private String statusModerate;

            @JsonProperty("additions_item_id")
            private Long additionsItemId;

            public String getCalloutText() {
                return calloutText;
            }

            public void setCalloutText(String calloutText) {
                this.calloutText = calloutText;
            }

            public String getStatusModerate() {
                return statusModerate;
            }

            public void setStatusModerate(String statusModerate) {
                this.statusModerate = statusModerate;
            }

            public Long getAdditionsItemId() {
                return additionsItemId;
            }

            public void setAdditionsItemId(Long additionsItemId) {
                this.additionsItemId = additionsItemId;
            }

            public Callout withCalloutText(String calloutText) {
                this.calloutText = calloutText;
                return this;
            }

            public Callout withStatusModerate(String statusModerate) {
                this.statusModerate = statusModerate;
                return this;
            }

            public Callout withAdditionsItemId(Long additionsItemId) {
                this.additionsItemId = additionsItemId;
                return this;
            }

            @Override
            public String toString() {
                return JsonUtils.toString(this);
            }

        }

        private static class BsInfo {

            @JsonProperty("BannerID")
            private Integer bannerId;

            @JsonProperty("place")
            private String place;

            @JsonProperty("min_price")
            private String minPrice;

            @JsonProperty("pclicks")
            private String pclicks;

            @JsonProperty("rshows")
            private String rshows;

            @JsonProperty("PhraseID")
            private Integer phraseId;

            @JsonProperty("ectr")
            private String ectr;

            @JsonProperty("rclicks")
            private String rclicks;

            @JsonProperty("pshows")
            private String pshows;

            @JsonProperty("id")
            private Integer id;

            @JsonProperty("pos")
            private Integer pos;

            @JsonProperty("price")
            private String price;

            @JsonProperty("pectr")
            private String pectr;

            @JsonProperty("rank")
            private String rank;

            @JsonProperty("tragic")
            private String tragic;

            @JsonProperty("OrderID")
            private String orderID;

            @JsonProperty("BroadPhraseID")
            private String broadPhraseID;

            @JsonProperty("disable_an")
            private String disableAn;

            public Integer getBannerId() {
                return bannerId;
            }

            public void setBannerId(Integer bannerId) {
                this.bannerId = bannerId;
            }

            public BsInfo withBannerId(Integer bannerId) {
                this.bannerId = bannerId;
                return this;
            }

            public String getPlace() {
                return place;
            }

            public void setPlace(String place) {
                this.place = place;
            }

            public BsInfo withPlace(String place) {
                this.place = place;
                return this;
            }

            public String getMinPrice() {
                return minPrice;
            }

            public void setMinPrice(String minPrice) {
                this.minPrice = minPrice;
            }

            public BsInfo withMinPrice(String minPrice) {
                this.minPrice = minPrice;
                return this;
            }

            public String getPclicks() {
                return pclicks;
            }

            public void setPclicks(String pclicks) {
                this.pclicks = pclicks;
            }

            public BsInfo withPclicks(String pclicks) {
                this.pclicks = pclicks;
                return this;
            }

            public String getRshows() {
                return rshows;
            }

            public void setRshows(String rshows) {
                this.rshows = rshows;
            }

            public BsInfo withRshows(String rshows) {
                this.rshows = rshows;
                return this;
            }

            public Integer getPhraseId() {
                return phraseId;
            }

            public void setPhraseId(Integer phraseId) {
                this.phraseId = phraseId;
            }

            public BsInfo withPhraseId(Integer phraseId) {
                this.phraseId = phraseId;
                return this;
            }

            public String getEctr() {
                return ectr;
            }

            public void setEctr(String ectr) {
                this.ectr = ectr;
            }

            public BsInfo withEctr(String ectr) {
                this.ectr = ectr;
                return this;
            }

            public String getRclicks() {
                return rclicks;
            }

            public void setRclicks(String rclicks) {
                this.rclicks = rclicks;
            }

            public BsInfo withRclicks(String rclicks) {
                this.rclicks = rclicks;
                return this;
            }

            public String getPshows() {
                return pshows;
            }

            public void setPshows(String pshows) {
                this.pshows = pshows;
            }

            public BsInfo withPshows(String pshows) {
                this.pshows = pshows;
                return this;
            }

            public Integer getId() {
                return id;
            }

            public void setId(Integer id) {
                this.id = id;
            }

            public BsInfo withId(Integer id) {
                this.id = id;
                return this;
            }

            public Integer getPos() {
                return pos;
            }

            public void setPos(Integer pos) {
                this.pos = pos;
            }

            public BsInfo withPos(Integer pos) {
                this.pos = pos;
                return this;
            }

            public String getPrice() {
                return price;
            }

            public void setPrice(String price) {
                this.price = price;
            }

            public BsInfo withPrice(String price) {
                this.price = price;
                return this;
            }

            public String getPectr() {
                return pectr;
            }

            public void setPectr(String pectr) {
                this.pectr = pectr;
            }

            public BsInfo withPectr(String pectr) {
                this.pectr = pectr;
                return this;
            }

            public String getRank() {
                return rank;
            }

            public void setRank(String rank) {
                this.rank = rank;
            }

            public BsInfo withRank(String rank) {
                this.rank = rank;
                return this;
            }

            public String getTragic() {
                return tragic;
            }

            public void setTragic(String tragic) {
                this.tragic = tragic;
            }

            public BsInfo withTragic(String tragic) {
                this.tragic = tragic;
                return this;
            }

            public String getOrderID() {
                return orderID;
            }

            public void setOrderID(String orderID) {
                this.orderID = orderID;
            }

            public BsInfo withOrderID(String orderID) {
                this.orderID = orderID;
                return this;
            }

            public String getBroadPhraseID() {
                return broadPhraseID;
            }

            public void setBroadPhraseID(String broadPhraseID) {
                this.broadPhraseID = broadPhraseID;
            }

            public BsInfo withBroadPhraseID(String broadPhraseID) {
                this.broadPhraseID = broadPhraseID;
                return this;
            }

            public String getDisableAn() {
                return disableAn;
            }

            public void setDisableAn(String disableAn) {
                this.disableAn = disableAn;
            }

            public BsInfo withDisableAn(String disableAn) {
                this.disableAn = disableAn;
                return this;
            }

            @Override
            public String toString() {
                return JsonUtils.toString(this);
            }
        }

    }
}
