package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by pavryabov on 27.08.15.
 */
public class BsFrontAuthResponse {

    public static final String OPERATOR_UID_NOT_FOUND = "operator uid %s not found";
    public static final String CLIENT_LOGIN_NOT_FOUND = "client login '%s' not found";
    public static final String INCORRECT_OPERATOR_UID = "incorrect param operator_uid(must be positive int)";
    public static final String INCORRECT_CREATIVE_ID = "incorrect param creative_id(must be positive int)";
    public static final String PARAMS_AMBIGUOUS = "params creative_id/creatives are ambiguous";

    public static final List<String> getActions = Arrays.asList(AvailableActions.CREATIVE_GET.toString());
    public static final List<String> allActions = Arrays.asList(
            AvailableActions.CREATIVE_CREATE.toString(),
            AvailableActions.CREATIVE_EDIT.toString(),
            AvailableActions.CREATIVE_DELETE.toString(),
            AvailableActions.CREATIVE_GET.toString()
    );
    public static final List<String> allActionsWithoutDelete = Arrays.asList(
            AvailableActions.CREATIVE_GET.toString(),
            AvailableActions.CREATIVE_CREATE.toString(),
            AvailableActions.CREATIVE_EDIT.toString()
    );

    public static final List<Integer> genericTemplates =
            Arrays.asList(320, 330, 331, 332, 333, 334, 335, 336, 337, 560, 553,
                    561, 559, 554, 555, 556, 557, 558, 694, 692);

    public static final List<Integer> superTemplates = Arrays.asList(547, 619, 620, 684, 703, 704, 706, 707, 708, 713);

    @JsonProperty("availableActions")
    List<String> availableActions;

    @JsonProperty("availableTemplates")
    List<Integer> availableTemplates;

    public List<String> getAvailableActions() {
        return availableActions;
    }

    public void setAvailableActions(List<String> availableActions) {
        this.availableActions = availableActions;
    }

    public List<Integer> getAvailableTemplates() {
        return availableTemplates;
    }

    public void setAvailableTemplates(List<Integer> availableTemplates) {
        this.availableTemplates = availableTemplates;
    }

    public static List<Integer> getAllTemplates() {
        List<Integer> allTemplates = new ArrayList(genericTemplates);
        allTemplates.addAll(superTemplates);
        return allTemplates;
    }
}
