package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Created by pavryabov on 27.08.15.
 */
public class BsFrontRequest {

    //Для ручек BsFront
    public static final Long CREATIVE1 = 1187423L; //240x400
    public static final Long CREATIVE2 = 1187435L;  //300x250
    public static final Long CREATIVE_NEW = 1187406L;
    public static final Long CREATIVE_YES1 = 1187445L; //!поменять в БД
    public static final Long CREATIVE_YES2 = 1187443L; //!поменять в БД
    public static final Long CREATIVE_NO1 = 1187446L;  //!поменять в БД
    public static final Long CREATIVE_NO2 = 1187444L;  //!поменять в БД
    public static final Long CREATIVE_CHECK_STATUS = 1187447L;

    @JsonProperty("operator_uid")
    private Integer operatorUid;

    @JsonProperty("client_login")
    private String clientLogin;

    @JsonProperty("creative_id")
    private Long creativeId;

    @JsonProperty("creatives")
    private List<Creative> creatives;


    public BsFrontRequest withOperatorUid(Integer operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public BsFrontRequest withClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public BsFrontRequest withCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public BsFrontRequest withCreatives(Creative... creatives) {
        this.creatives = Arrays.asList(creatives);
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
