package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

public class IntapiTurboLanding {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String COUNTERS = "counters";
    public static final String VERSION = "version";
    public static final String PREVIEW_HREF = "previewHref";
    public static final String PRESET = "preset";
    public static final String MODERATION_REQURED = "contentModerationRequired";
    public static final String MODERATION_STATUS = "moderationStatus";

    @JsonProperty(ID)
    private Long id;

    @JsonProperty(NAME)
    private String name;

    @JsonProperty(URL)
    private String url;

    @JsonProperty(COUNTERS)
    private List<IntapiTurboLandingCounter> counters;

    @JsonProperty(VERSION)
    private Long version;

    @JsonProperty(PREVIEW_HREF)
    private String previewHref;

    @Nullable
    @JsonProperty(MODERATION_REQURED)
    private Boolean contentModerationRequired;

    @Nullable
    @JsonProperty(MODERATION_STATUS)
    private TurboPageModerationStatusEnum turboPageModerationStatus;

    @Nullable
    @JsonProperty(PRESET)
    private String preset;

    public Long getId() {
        return id;
    }

    public IntapiTurboLanding withId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public IntapiTurboLanding withName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public IntapiTurboLanding withUrl(String url) {
        this.url = url;
        return this;
    }

    public List<IntapiTurboLandingCounter> getCounters() {
        return counters;
    }

    public IntapiTurboLanding withCounters(List<IntapiTurboLandingCounter> counters) {
        this.counters = counters;
        return this;
    }

    public Long getVersion() {
        return version;
    }

    public IntapiTurboLanding withVersion(Long version) {
        this.version = version;
        return this;
    }

    public String getPreviewHref() {
        return previewHref;
    }

    public IntapiTurboLanding withPreviewHref(String previewHref) {
        this.previewHref = previewHref;
        return this;
    }

    @Nullable
    public String getPreset() {
        return preset;
    }

    public IntapiTurboLanding withPreset(@Nullable String preset) {
        this.preset = preset;
        return this;
    }

    @Nullable
    public Boolean getContentModerationRequired() {
        return contentModerationRequired;
    }

    public IntapiTurboLanding withContentModerationRequired(@Nullable Boolean contentModerationRequired) {
        this.contentModerationRequired = contentModerationRequired;
        return this;
    }

    @Nullable
    public TurboPageModerationStatusEnum getTurboPageModerationStatus() {
        return turboPageModerationStatus;
    }

    public IntapiTurboLanding withTurboPageModerationStatus(
            @Nullable TurboPageModerationStatusEnum turboPageModerationStatus) {
        this.turboPageModerationStatus = turboPageModerationStatus;
        return this;
    }

    public enum TurboPageModerationStatusEnum {
        READY,
        YES,
        NO
    }


}
