package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.campaigninfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Created by pavryabov on 02.12.15.
 */
public class GetCampaignInfoItem {

    public static final String NOT_FOUND = "not_found";
    public static final String INCORRECT_ARGS = "INCORRECT_ARGS";

    @JsonProperty("ClientID")
    private String clientID;

    @JsonProperty("cid")
    private String cid;

    @JsonProperty("bids")
    private List<String> bids;

    @JsonProperty("OrderID")
    private String orderID;

    @JsonProperty("error")
    private String error;

    @JsonProperty("description")
    private String description;

    @JsonProperty("code")
    private String code;

    public String getCid() {
        return cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public List<String> getBids() {
        return bids;
    }

    public void setBids(List<String> bids) {
        this.bids = bids;
    }

    public String getClientID() {
        return clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getOrderID() {
        return orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GetCampaignInfoItem withClientID(String clientID) {
        this.setClientID(clientID);
        return this;
    }

    public GetCampaignInfoItem withCid(String cid) {
        this.setCid(cid);
        return this;
    }

    public GetCampaignInfoItem withBids(String... bids) {
        this.setBids(Arrays.asList(bids));
        return this;
    }

    public GetCampaignInfoItem withOrderID(String orderID) {
        this.setOrderID(orderID);
        return this;
    }

    public GetCampaignInfoItem withError(String error) {
        this.setError(error);
        return this;
    }

    public GetCampaignInfoItem withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public GetCampaignInfoItem withCode(String code) {
        this.setCode(code);
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
