package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.campaigninfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Created by pavryabov on 02.12.15.
 */
public class GetCampaignInfoRequest {

    @JsonProperty("cids")
    private List<Long> cids;

    @JsonProperty("bids")
    private List<Long> bids;

    @JsonProperty("fields")
    private List<String> fields;

    public List<Long> getCids() {
        return cids;
    }

    public void setCids(List<Long> cids) {
        this.cids = cids;
    }

    public List<Long> getBids() {
        return bids;
    }

    public void setBids(List<Long> bids) {
        this.bids = bids;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public GetCampaignInfoRequest withCids(Long... cids) {
        this.setCids(Arrays.asList(cids));
        return this;
    }

    public GetCampaignInfoRequest withBids(Long... bids) {
        this.setBids(Arrays.asList(bids));
        return this;
    }

    public GetCampaignInfoRequest withFields(String... fields) {
        this.setFields(Arrays.asList(fields));
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
