package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.campaigninfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by pavryabov on 02.12.15.
 */
public class GetCampaignInfoResponse {

    @JsonProperty("result")
    private List<GetCampaignInfoItem> result;

    @JsonProperty("error")
    private GetCampaignInfoItem error;

    public List<GetCampaignInfoItem> getResult() {
        return result;
    }

    public void setResult(List<GetCampaignInfoItem> result) {
        this.result = result;
    }

    public GetCampaignInfoItem getError() {
        return error;
    }

    public void setError(GetCampaignInfoItem error) {
        this.error = error;
    }

    public GetCampaignInfoResponse withResult(GetCampaignInfoItem... items) {
        this.setResult(Arrays.asList(items));
        return this;
    }

    public GetCampaignInfoResponse withError(GetCampaignInfoItem item) {
        this.setError(item);
        return this;
    }

    public GetCampaignInfoResponse sortResultByCid() {
        this.result = this.result.stream()
                .sorted((a, b) -> Integer.compare(Integer.valueOf(a.getCid()), Integer.valueOf(b.getCid())))
                .collect(Collectors.toList());
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
