package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.directenv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

/*
* todo javadoc
*/

public enum DirectPropertiesKeys {
    AD_DESIGNER_URL,
    BS_API_URL,
    BS_HOST_EXPORT,
    CONFIGURATION,
    BANNER_STORAGE_API_URL("BannerStorage::BANNER_STORAGE_API_URL"),
    DB_CONFIG_UNICORN_NODE;

    private String key;

    DirectPropertiesKeys() {
    }

    DirectPropertiesKeys(String key) {
        this.key = key;
    }

    @JsonCreator
    public static DirectPropertiesKeys forValue(String value) {
        try {
            return DirectPropertiesKeys.valueOf(value);
        } catch (IllegalArgumentException ex) {
            for (DirectPropertiesKeys enumVal : DirectPropertiesKeys.values()) {
                if (StringUtils.equals(enumVal.key, value)) {
                    return enumVal;
                }
            }
            return null;
        }
    }

    @JsonValue
    public String toValue() {
        if (key == null) {
            return this.toString();
        }
        return key;
    }
}
