package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Created by pashkus on 08.09.16.
 * Data model for ../DisplayCanvas/update_creatives request
 * Technical design: https://wiki.yandex-team.ru/Direkt/TechnicalDesign/creative-canvas/#vzaimodejjstviekkonstruktoromcherezintapi
 */
public class UpdateCreativesReq {

    @JsonProperty("creative_id")
    public Long creativeId;

    @JsonProperty("creative_name")
    public String creative_name;

    @JsonProperty("preview_url")
    public String previewUrl;

    @JsonProperty("width")
    public Integer width;

    @JsonProperty("height")
    public Integer height;

    @JsonProperty("modiration_info")
    public ModerationInfo moderationInfo;

    public Long getCreativeId() {
        return creativeId;
    }

    public String getCreative_name() {
        return creative_name;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }

    public ModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public UpdateCreativesReq setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public UpdateCreativesReq setCreative_name(String creative_name) {
        this.creative_name = creative_name;
        return this;
    }

    public UpdateCreativesReq setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public UpdateCreativesReq setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public UpdateCreativesReq setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public UpdateCreativesReq setModerationInfo(ModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
        return this;
    }
}
