package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake;

import com.googlecode.jsonrpc4j.JsonRpcParam;

import java.util.Map;

/**
 * User: xy6er
 */

public interface FakeAdminService {
    public static final String SERVICE_NAME = "FakeAdmin";

    /*
        Имена методов должны в точности соответствовать названиям в апи.
     */
    public CampaignFakeInfo FakeGetCampaignParams(@JsonRpcParam("cid") int cid);

    public BannerFakeInfo FakeGetBannerParams(@JsonRpcParam("bid") Long bid);

    public GroupFakeInfo FakeGetGroupParams(@JsonRpcParam("pid") Long adGroupID);

    public BannerPhraseFakeInfo[] FakeGetPhrasesParams(@JsonRpcParam("id") long id);

    public BannerPhraseFakeInfo[] FakeGetPhrasesParams(@JsonRpcParam("pid") String pid);

    public ClientFakeInfo FakeGetClientParams(
            @JsonRpcParam("login") String login, @JsonRpcParam("fields") String[] fields);

    public Boolean FakeSetAllowBudgetAccountForAgency(
            @JsonRpcParam("Login") String login, @JsonRpcParam("YesNo") String yesNo);

    public Boolean ReshardUser(@JsonRpcParam("Login") String login, @JsonRpcParam("Shard") int shard);

    public Boolean ReshardUser(@JsonRpcParam("ClientID") int clientID, @JsonRpcParam("Shard") int shard);

    public Integer GetUserShard(@JsonRpcParam("ClientID") int clientID);

    public Integer GetUserShard(@JsonRpcParam("Login") String login);

    public Boolean FakeCreateReportQueue(
            @JsonRpcParam("ReportType") String reportType,
            @JsonRpcParam("ReportID") int reportID);

    public RetargetingConditionFakeInfo FakeUpdateRetargetingGoals(@JsonRpcParam("ConditionID") int conditionID);

    public Boolean FakeRemoveAgencyClientRelation(@JsonRpcParam("AgencyID") int agencyID,
                                                  @JsonRpcParam("ClientID") int clientID);

    public Integer FakeClearClientSpentUnits(@JsonRpcParam("client_id") int clientID);

    public Integer FakeClientUnitsBalance(@JsonRpcParam("client_id") int clientID);

    public Integer FakeWithdrawClientUnits(@JsonRpcParam("client_id") int clientID, @JsonRpcParam("amount") int amount);

    public Integer FakeCreateClient(@JsonRpcParam("Login") String login,
                                    @JsonRpcParam("Password") String password,
                                    @JsonRpcParam("Name") String name,
                                    @JsonRpcParam("Surname") String surname,
                                    @JsonRpcParam("Currency") String currency);

    TakeRedisLockResult TakeRedisLock(@JsonRpcParam("key") String key, @JsonRpcParam("ttl") long ttl);

    Map DropRedisLock(@JsonRpcParam("locks") Object lock);

    Map SendCampaignToBalance(@JsonRpcParam("cid") long cid);
}
