package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by semkagtn on 11/26/14.
 */
public class MailLogsRequest {

    @JsonProperty("cids")
    private Long[] cids;

    @JsonProperty("uids")
    private Long[] uids;

    @JsonProperty("logins")
    private String[] logins;

    @JsonProperty("emails")
    private String[] emails;

    @JsonProperty("template_names")
    private MailTemplate[] templateNames;

    @JsonProperty("date_from")
    private String dateFrom;

    @JsonProperty("date_to")
    private String dateTo;

    public Long[] getCids() {
        return cids;
    }

    public void setCids(Long[] cids) {
        this.cids = cids;
    }

    public Long[] getUids() {
        return uids;
    }

    public void setUids(Long[] uids) {
        this.uids = uids;
    }

    public String[] getLogins() {
        return logins;
    }

    public void setLogins(String[] logins) {
        this.logins = logins;
    }

    public String[] getEmails() {
        return emails;
    }

    public void setEmails(String[] emails) {
        this.emails = emails;
    }

    public MailTemplate[] getTemplateNames() {
        return templateNames;
    }

    public void setTemplateNames(MailTemplate[] templateNames) {
        this.templateNames = templateNames;
    }

    public String getDateFrom() {
        return dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public MailLogsRequest withCids(Long... cids) {
        this.cids = cids;
        return this;
    }

    public MailLogsRequest withUids(Long... uids) {
        this.uids = uids;
        return this;
    }

    public MailLogsRequest withLogins(String... logins) {
        this.logins = logins;
        return this;
    }

    public MailLogsRequest withEmails(String... emails) {
        this.emails = emails;
        return this;
    }

    public MailLogsRequest withTemplateNames(MailTemplate... templateNames) {
        this.templateNames = templateNames;
        return this;
    }

    public MailLogsRequest withDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public MailLogsRequest withDateTo(String dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
