package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by semkagtn on 11/26/14.
 */
public class MailLogsResponse {

    @JsonProperty("email")
    private String email;

    @JsonProperty("template_name")
    private MailTemplate templateName;

    @JsonProperty("subject")
    private String subject;

    @JsonProperty("content")
    private String content;

    @JsonProperty("logtime_format")
    private String logtimeFormat;

    @JsonProperty("logtime_unixtime")
    private Long logtimeUnixtime;

    @JsonProperty("client_id")
    private Long clientId;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public MailTemplate getTemplateName() {
        return templateName;
    }

    public void setTemplateName(MailTemplate templateName) {
        this.templateName = templateName;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getLogtimeFormat() {
        return logtimeFormat;
    }

    public void setLogtimeFormat(String logtimeFormat) {
        this.logtimeFormat = logtimeFormat;
    }

    public Long getLogtimeUnixtime() {
        return logtimeUnixtime;
    }

    public void setLogtimeUnixtime(Long logtimeUnixtime) {
        this.logtimeUnixtime = logtimeUnixtime;
    }

    public Long getClientId() {
        return null;
    }

    public MailLogsResponse withEmail(String email) {
        this.email = email;
        return this;
    }

    public MailLogsResponse withTemplateName(MailTemplate templateName) {
        this.templateName = templateName;
        return this;
    }

    public MailLogsResponse withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public MailLogsResponse withContent(String content) {
        this.content = content;
        return this;
    }

    public MailLogsResponse withLogtimeFormat(String logtimeFormat) {
        this.logtimeFormat = logtimeFormat;
        return this;
    }

    public MailLogsResponse withLogtimeUnixtime(Long logtimeUnixtime) {
        this.logtimeUnixtime = logtimeUnixtime;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
