package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.metrica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * User: omaz
 * Date: 18.11.13
 * контейнер для ответа metrica_get_banners
 */
public class MetricaBannerData {
    private Integer isImageBanner;
    private Long bannerID;
    private Long bid;
    private Integer orderID;
    private String title;
    private String domain;
    private String body;

    public MetricaBannerData() {

    }

    @JsonCreator
    public MetricaBannerData(@JsonProperty("is_image_banner") Integer isImageBanner,
                             @JsonProperty("BannerID") Long bannerID,
                             @JsonProperty("bid") Long bid,
                             @JsonProperty("OrderID") Integer orderID,
                             @JsonProperty("title") String title,
                             @JsonProperty("domain") String domain,
                             @JsonProperty("body") String body){
        this.isImageBanner = isImageBanner;
        this.bannerID = bannerID;
        this.bid = bid;
        this.orderID = orderID;
        this.title = title;
        this.domain = domain;
        this.body = body;
    }

    public Integer getIsImageBanner() {
        return isImageBanner;
    }

    public Long getBannerID() {
        return bannerID;
    }

    public Long getBid() {
        return bid;
    }

    public Integer getOrderID() {
        return orderID;
    }

    public String getTitle() {
        return title;
    }

    public String getDomain() {
        return domain;
    }

    public String getBody() {
        return body;
    }

    public void setIsImageBanner(Integer isImageBanner) {
        this.isImageBanner = isImageBanner;
    }

    public void setBannerID(Long bannerID) {
        this.bannerID = bannerID;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public void setOrderID(Integer orderID) {
        this.orderID = orderID;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }

}
