package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.metrica;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.autotests.irt.testutils.collections.CollectionUtils;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * User: omaz
 * Date: 14.11.13
 * Контейнер для ответа функции metrika_get_campaigns
 */
public class MetricaCampaignData {

    private String metricaCounters;
    private String name;
    private Long cid;
    private Integer orderID;
    private String currency;
    private Integer clientID;

    public MetricaCampaignData() {

    }

    @JsonCreator
    public MetricaCampaignData(@JsonProperty("currency") String currency,
                               @JsonProperty("metrika_counters") String metricaCounters,
                               @JsonProperty("name") String name,
                               @JsonProperty("cid") Long cid,
                               @JsonProperty("OrderID") Integer orderID,
                               @JsonProperty("ClientID") Integer clientID
    ) {
        this.metricaCounters = metricaCounters;
        this.name = name;
        this.cid = cid;
        this.orderID = orderID;
        this.currency = currency;
        this.clientID = clientID;
    }

    public List<Integer> getMetricaCounters() {
        return CollectionUtils.stringToIntList(metricaCounters, ",");
    }

    public String getName() {
        return name;
    }

    public Long getCid() {
        return cid;
    }

    public Integer getOrderID() {
        return orderID;
    }

    public Integer getClientID() {
        return clientID;
    }

    public void setMetricaCounters(String metricaCounters) {
        this.metricaCounters = metricaCounters;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public void setOrderID(Integer orderID) {
        this.orderID = orderID;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setClientID(Integer clientID) {
        this.clientID = clientID;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
