package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.metrica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by pavryabov on 28.08.15.
 */
public class MetricaDynamicData {

    public static final String INVALID_PARAMETER_ORDER_ID = "Invalid parameter OrderID";
    public static final String INVALID_PARAMETER_DYN_COND_ID = "Invalid parameter dyn_cond_id";

    private Long dynCondId;
    private String conditionName;
    private Integer orderID;

    public MetricaDynamicData() {

    }

    @JsonCreator
    public MetricaDynamicData(@JsonProperty("dyn_cond_id") Long dynCondId,
                              @JsonProperty("condition_name") String conditionName,
                              @JsonProperty("OrderID") Integer orderID) {
        this.dynCondId = dynCondId;
        this.conditionName = conditionName;
        this.orderID = orderID;
    }

    public Long getDynCondId() {
        return dynCondId;
    }

    public void setDynCondId(Long dynCondId) {
        this.dynCondId = dynCondId;
    }

    public String getConditionName() {
        return conditionName;
    }

    public void setConditionName(String conditionName) {
        this.conditionName = conditionName;
    }

    public Integer getOrderID() {
        return orderID;
    }

    public void setOrderID(Integer orderID) {
        this.orderID = orderID;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
