package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.metrica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by ginger on 21.12.2015.
 */
public class MetricaPerformanceFiltersData {

    public static final String INVALID_PARAMETER_ORDER_ID = "Invalid parameter OrderID";
    public static final String INVALID_PARAMETER_PERF_FILTER_ID = "Invalid parameter perf_filter_id";

    private Integer perfFilterId;
    private String filterName;
    private Integer orderID;

    public MetricaPerformanceFiltersData() {

    }

    @JsonCreator
    public MetricaPerformanceFiltersData(@JsonProperty("perf_filter_id") Integer perfFilterId,
                              @JsonProperty("filter_name") String filterName,
                              @JsonProperty("OrderID") Integer orderID) {
        this.perfFilterId = perfFilterId;
        this.filterName = filterName;
        this.orderID = orderID;
    }

    public Integer getPerfFilterId() {
        return perfFilterId;
    }

    public void setPerfFilterId(Integer perfFilterId) {
        this.perfFilterId = perfFilterId;
    }

    public String getFilterName() {
        return filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public Integer getOrderID() {
        return orderID;
    }

    public void setOrderID(Integer orderID) {
        this.orderID = orderID;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
