package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.metrica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * User: omaz
 * Date: 14.11.13
 * Контейнер для ответа функции metrika_get_phrases
 */
public class MetricaPhraseData {

    private Long phraseID;
    private Integer orderID;
    private Long bidsID;
    private Long groupID;

    public MetricaPhraseData() {

    }

    @JsonCreator
    public MetricaPhraseData(@JsonProperty("PhraseID") Long phraseID,
                             @JsonProperty("OrderID") Integer orderID,
                             @JsonProperty("bids_id") Long bidsID,
                             @JsonProperty("GroupID") Long groupID) {
        this.phraseID = phraseID;
        this.orderID = orderID;
        this.bidsID = bidsID;
        this.groupID = groupID;
    }

    public Long getPhraseID() {
        return this.phraseID;
    }

    public Integer getOrderID() {
        return this.orderID;
    }

    public Long getBidsID() {
        return this.bidsID;
    }

    public Long getGroupID() {
        return this.groupID;
    }

    public void setPhraseID(Long phraseID) {
        this.phraseID = phraseID;
    }

    public void setOrderID(Integer orderID) {
        this.orderID = orderID;
    }

    public void setBidsID(Long bidsID) {
        this.bidsID = bidsID;
    }

    public void setGroupID(Long groupID) {
        this.groupID = groupID;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
