package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.moderation;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.autotests.directapi.darkside.model.ModerateTestDiags;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by buhter on 26/08/16.
 */
public class ErrorFromModeration {
    @JsonProperty("id")
    private Integer id;
    @JsonProperty("list")
    private List<PhraseError> phraseErrorList;

    public ErrorFromModeration() {
    }

    public ErrorFromModeration(String id) {
        this.id = Integer.parseInt(id);
        phraseErrorList = null;
    }

    public ErrorFromModeration(ModerateTestDiags moderationError) {
        this.id = moderationError.getDiagId();
        phraseErrorList = null;
    }

    public Integer getId() {
        return id;
    }

    public List<PhraseError> getPhraseErrorList() {
        return phraseErrorList;
    }

    public void setPhraseErrorList(List<PhraseError> phraseErrorList) {
        this.phraseErrorList = phraseErrorList;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ErrorFromModeration withPhraseErrorList(List<PhraseError> phraseErrorList) {
        this.phraseErrorList = phraseErrorList;
        return this;
    }

    public ErrorFromModeration withId(Integer id) {
        this.id = id;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
