package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.moderation;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.autotests.direct.fakebsproxy.beans.moderate.enums.ModerationObjectTypeEnum;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by buhter on 11.07.16.
 */
public class ProcessModResultItem<T> {
    @JsonProperty("bid")
    private Long bid;
    @JsonProperty("catalogia_ids")
    private List<Long> catalogiaIds;
    @JsonProperty("cid")
    private Long cid;
    @JsonProperty("client_id")
    private Long clientId;
    @JsonProperty("errors")
    private List<ErrorFromModeration> errors;
    @JsonProperty("export_version")
    private String exportVersion;
    @JsonProperty("flags")
    private Map<String, String> flags;
    @JsonProperty("force")
    private Integer force;
    @JsonProperty("id")
    private Long id;
    @JsonProperty("object_id")
    private Long objectId;
    @JsonProperty("content_id")
    private Long contentId;
    @JsonProperty("callout_id")
    private Long calloutId;
    @JsonProperty("pid")
    private Long pid;
    @JsonProperty("image_text")
    private String imageText;
    @JsonProperty("dyn_disclaimer")
    private String dynDisclaimer;
    @JsonProperty("minus_regions")
    private List<String> minusRegions;
    @JsonProperty("disclaimer_text")
    private String disclaimerText;
    @JsonProperty("statusModerate")
    private String statusModerate;
    @JsonProperty("statusPostModerate")
    private String statusPostModerate;
    @JsonProperty("statusSync")
    private String statusSync;
    @JsonProperty("type")
    private String type;
    @JsonProperty("process_error_text")
    private String processErrorText;
    @JsonProperty("process_error")
    private String processError;


    public Long getBid() {
        return bid;
    }

    public List<Long> getCatalogiaIds() {
        return catalogiaIds;
    }

    public Long getCid() {
        return cid;
    }

    public List<ErrorFromModeration> getErrors() {
        return errors;
    }

    public String getExportVersion() {
        return exportVersion;
    }

    public Map<String, String> getFlags() {
        return flags;
    }

    public Integer getForce() {
        return force;
    }

    public Long getId() {
        return id;
    }

    public Long getObjectId() {
        return objectId;
    }

    public Long getContentId() {
        return contentId;
    }

    public Long getCalloutId() {
        return calloutId;
    }

    public Long getPid() {
        return pid;
    }

    public String getStatusModerate() {
        return statusModerate;
    }

    public String getStatusPostModerate() {
        return statusPostModerate;
    }

    public String getStatusSync() {
        return statusSync;
    }

    public String getType() {
        return type;
    }

    public String getImageText() {
        return imageText;
    }

    public String getDisclaimerText() {
        return disclaimerText;
    }

    public Long getClientId() {
        return clientId;
    }

    public String getProcessErrorText() {
        return processErrorText;
    }

    public String getProcessError() {
        return processError;
    }

    public String getDynDisclaimer() {
        return dynDisclaimer;
    }

    public List<String> getMinusRegions() {
        return minusRegions;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public void setCatalogiaIds(List<Long> catalogiaIds) {
        this.catalogiaIds = catalogiaIds;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public void setErrors(List<ErrorFromModeration> errors) {
        this.errors = errors;
    }

    public void setExportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
    }

    public void setFlags(Map<String, String> flags) {
        this.flags = flags;
    }

    public void setForce(Integer force) {
        this.force = force;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public void setCalloutId(Long calloutId) {
        this.calloutId = calloutId;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setStatusModerate(String statusModerate) {
        this.statusModerate = statusModerate;
    }

    public void setStatusPostModerate(String statusPostModerate) {
        this.statusPostModerate = statusPostModerate;
    }

    public void setStatusSync(String statusSync) {
        this.statusSync = statusSync;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setImageText(String imageText) {
        this.imageText = imageText;
    }

    public void setDisclaimerText(String disclaimerText) {
        this.disclaimerText = disclaimerText;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public void setProcessErrorText(String processErrorText) {
        this.processErrorText = processErrorText;
    }

    public void setProcessError(String processError) {
        this.processError = processError;
    }

    public void setDynDisclaimer(String dynDisclaimer) {
        this.dynDisclaimer = dynDisclaimer;
    }

    public void setMinusRegions(List<String> minusRegions) {
        this.minusRegions = minusRegions;
    }

    public ProcessModResultItem withBid(Long bid) {
        this.bid = bid;
        return this;
    }

    public ProcessModResultItem withCatalogiaIds(List<Long> catalogiaIds) {
        this.catalogiaIds = catalogiaIds;
        return this;
    }

    public ProcessModResultItem withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public ProcessModResultItem withErrors(List<ErrorFromModeration> errors) {
        this.errors = errors;
        return this;
    }

    public ProcessModResultItem withExportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
        return this;
    }

    public ProcessModResultItem withFlags(Map<String, String> flags) {
        this.flags = flags;
        return this;
    }

    public ProcessModResultItem withForce(Integer force) {
        this.force = force;
        return this;
    }

    public ProcessModResultItem withId(Long id) {
        this.id = id;
        return this;
    }

    public ProcessModResultItem withObjectId(Long objectId) {
        this.objectId = objectId;
        return this;
    }

    public ProcessModResultItem withContentId(Long contentId) {
        this.contentId = contentId;
        return this;
    }

    public ProcessModResultItem withCalloutId(Long calloutId) {
        this.calloutId = calloutId;
        return this;
    }

    public ProcessModResultItem withPid(Long pid) {
        this.pid = pid;
        return this;
    }

    public ProcessModResultItem withStatusModerate(String statusModerate) {
        this.statusModerate = statusModerate;
        return this;
    }

    public ProcessModResultItem withStatusPostModerate(String statusPostModerate) {
        this.statusPostModerate = statusPostModerate;
        return this;
    }

    public ProcessModResultItem withStatusSync(String statusSync) {
        this.statusSync = statusSync;
        return this;
    }

    public ProcessModResultItem withType(String type) {
        this.type = type;
        return this;
    }

    public ProcessModResultItem withType(ModerationObjectTypeEnum type) {
        this.type = type.getValue();
        return this;
    }

    public ProcessModResultItem withImageText(String imageText) {
        this.imageText = imageText;
        return this;
    }

    public ProcessModResultItem withDisclaimerText(String disclaimerText) {
        this.disclaimerText = disclaimerText;
        return this;
    }

    public ProcessModResultItem withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public ProcessModResultItem withProcessErrorText(String processErrorText) {
        this.processErrorText = processErrorText;
        return this;
    }

    public ProcessModResultItem withProcessError(String processError) {
        this.processError = processError;
        return this;
    }

    public ProcessModResultItem withDynDisclaimer(String dynDisclaimer) {
        this.dynDisclaimer = dynDisclaimer;
        return this;
    }

    public ProcessModResultItem withMinusRegions(List<String> minusRegions) {
        this.minusRegions = minusRegions;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
