package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.moderation.dataitem;

/**
 * Created by buhter on 09.12.15.
 */
public enum DeleteDocumentsError {

    UNKNOWN_SHARD(1, "unknown shard for ClientID %s"),
    WRONG_CLIENT_ID(3, "wrong ClientID for doc_id %s. Got ClientID %s. Expected ClientID %s"),
    INVALID_CLIENT_ID(5, "invalid ClientID"),
    INVALID_DOC_ID(6, "invalid doc_id, must be greater than zero"),
    NOT_FOUND_DOC_ID(8, "not found doc_id %s in shard %s");

    private String processErrorText;
    private Integer processError;

    DeleteDocumentsError(Integer processError, String processErrorText) {
        this.processError = processError;
        this.processErrorText = processErrorText;
    }

    public String getProcessErrorText() {
        return processErrorText;
    }

    public void setProcessErrorText(String processErrorText) {
        this.processErrorText = processErrorText;
    }

    public Integer getProcessError() {
        return processError;
    }

    public void setProcessError(Integer processError) {
        this.processError = processError;
    }

    @Override
    public String toString() {
        return processErrorText;
    }


    private DeleteDocumentsError() {
    }
}
