package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.officecontact;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

public class YandexOfficeRequest {
    @JsonProperty("lang")
    private String lang;

    @JsonProperty("geo_id")
    private Long geoId;

    @JsonProperty("domain")
    private String domain;

    public String getDomain() {
        return domain;
    }

    public YandexOfficeRequest withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Long getGeoId() {
        return geoId;
    }

    public YandexOfficeRequest withGeoId(Long geoId) {
        this.geoId = geoId;
        return this;
    }

    public String getLang() {
        return lang;
    }

    public YandexOfficeRequest withLang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
