package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.sandbox;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * @author egorovmv
 */
public final class StatusResponse {
    private static final String OK_CODE = "OK";

    private final String code;
    private final String description;

    @JsonCreator
    public StatusResponse(
            @JsonProperty("code") String code, @JsonProperty("descr") String description)
    {
        this.code = Objects.requireNonNull(code, "code");
        this.description = description;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public boolean isFail() {
        return !OK_CODE.equals(code);
    }
}
