package ru.yandex.autotests.directapi.darkside.datacontainers.soap;


import org.w3c.dom.Document;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.*;

/**
 * User: rockman
 * Date: 15.08.13
 */
public class BaseSoapRequest {
    protected String methodName;
    /**
     * Класс, описывающий структуру запроса
     */
    protected Class requestClass;
    /**
     * Экземпляр класса requestClass
     */
    protected Object requestObject;

    public BaseSoapRequest(Object requestObject) {
        this.requestClass = requestObject.getClass();
        this.requestObject = requestObject;

    }

    public BaseSoapRequest() {

    }

    public void generateSOAPMessage(SOAPMessage soapMessage) {
        try {
            marshallSOAPMessage(soapMessage);
            soapMessage.saveChanges();
        } catch (SOAPException e) {
            throw new DarkSideException("Ошибка серилизации объекта", e);
        }
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void marshallSOAPMessage(SOAPMessage soapMessage) throws SOAPException {
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        soapEnvelope.addNamespaceDeclaration("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        soapEnvelope.addNamespaceDeclaration("xsi", "http://www.w3.org/1999/XMLSchema-instance");
        soapEnvelope.addNamespaceDeclaration("namesp1", "ServiceSOAP");
        SOAPElement methodNode = soapMessage.getSOAPBody().addChildElement(methodName, "namesp1", "ServiceSOAP");
        SOAPElement params = methodNode.addChildElement("Params");
        Document document;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Marshaller marshaller = JAXBContext.newInstance(requestClass).createMarshaller();
            marshaller.marshal(requestObject, document);
        } catch (JAXBException e) {
            throw new DarkSideException("Не удалось распарсить запрос", e);
        } catch (ParserConfigurationException e) {
            throw new DarkSideException("Не удалось распарсить запрос", e);
        }
        SOAPElement requestElement = MessageFactory.newInstance().createMessage().getSOAPBody().addDocument(document);
        params.addChildElement(requestElement);
    }

    public Object getRequestObject() {
        return requestClass.cast(requestObject);
    }
}
