package ru.yandex.autotests.directapi.darkside.datacontainers.soap;

import org.w3c.dom.NodeList;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

/**
 * User: rockman
 * Date: 15.08.13
 */
public class BaseSoapResponse {

    /**
     * Класс, описывающий структуру ответа
     */
    protected Class responseClass;
    /**
     * Экземпляр класса responseClass
     */
    protected Object responseObject;

    public BaseSoapResponse(Class responseClass) {
        this.responseClass = responseClass;
        try {
            this.responseObject = responseClass.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            throw new DarkSideException("Не удалось создать экземпляр объекта " + responseClass, e);
        }
    }

    public BaseSoapResponse() {
    }

    public void unmarshallSOAPMessage(SOAPMessage soapMessage) throws SOAPException {
        SOAPElement response;
        try {
            response = (SOAPElement) soapMessage.getSOAPBody().getFirstChild().getFirstChild().getFirstChild();
        } catch (SOAPException e) {
            throw new DarkSideException("Ошибка парсинга SOAP-сообщения", e);
        }
        JAXBContext jaxbContext;
        Unmarshaller jaxbUnmarshaller;
        try {
            jaxbContext = JAXBContext.newInstance(responseClass);
            jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            responseObject = jaxbUnmarshaller.unmarshal(response);

        } catch (JAXBException e) {
            throw new DarkSideException("Не удалось распарсить ответ", e);
        }
    }

    public Object getResponseObject() {
        return responseClass.cast(responseObject);
    }

    protected static SOAPElement childByName(SOAPElement soapElement, String childName) {
        return (SOAPElement) soapElement.getChildElements(QName.valueOf(childName)).next();
    }
}
