package ru.yandex.autotests.directapi.darkside.datacontainers.soap;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

/**
 * User: omaz
 * Date: 11.09.13
 * Контейнер ответа для методов, которые не умеют возвращать ошибки, а возвращают только код ответа
 */

public class EmptyResponseData extends BaseSoapResponse {
    private int exitCode = 1;

    public int getExitCode() {
        return exitCode;
    }

    @Override
    public void unmarshallSOAPMessage(SOAPMessage soapMessage) throws SOAPException {
        SOAPElement responce = (SOAPElement) soapMessage.getSOAPBody().getFirstChild().getFirstChild();
        exitCode = Integer.valueOf(responce.getTextContent());
    }

    @Override
    public Object getResponseObject() {
        return exitCode;
    }

}
