package ru.yandex.autotests.directapi.darkside.datacontainers.soap;


import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

/**
 * User: xy6er
 * Date: 26.05.14
 */

public class ErrorResponseData extends BaseSoapResponse {
    private String exitCode;
    private String message;

    public ErrorResponseData() {
    }

    public ErrorResponseData(String exitCode, String message) {
        this.exitCode = exitCode;
        this.message = message;
    }

    public String getExitCode() {
        return exitCode;
    }

    public void setExitCode(String exitCode) {
        this.exitCode = exitCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void unmarshallSOAPMessage(SOAPMessage soapMessage) throws SOAPException {
        SOAPElement response = (SOAPElement) soapMessage.getSOAPBody().getFirstChild();
        if (response.getElementName().getPrefix().startsWith("namesp")) {
            //для метода setYacobotCategoriesResponse есть еще одна вложенность
            response = (SOAPElement) response.getFirstChild();
        }
        exitCode = response.getFirstChild().getTextContent();
        message = response.getLastChild().getTextContent();
    }

    @Override
    public Object getResponseObject() {
        return exitCode + " " + message; //TODO-b
    }

}
