package ru.yandex.autotests.directapi.darkside.datacontainers.soap;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import java.util.Map;

/**
 * User: xy6er
 * Date: 14.05.14
 * Контейнер запроса для методов, которые принимают хеш таблицу с парами ID => Value.
 * Не стоит передавать сложные объекты, т.к. ID и Value преобразовываются в String
 */
public class HashRequestData extends BaseSoapRequest {

    public HashRequestData(Map params) {
        this.requestObject = params;
        this.requestClass = params.getClass();
    }

    @Override
    public void marshallSOAPMessage(SOAPMessage soapMessage) throws SOAPException {
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        soapEnvelope.addNamespaceDeclaration("xsi", "http://www.w3.org/1999/XMLSchema-instance");
        soapEnvelope.addNamespaceDeclaration("apachens", "http://xml.apache.org/xml-soap");
        soapEnvelope.addNamespaceDeclaration("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");

        SOAPElement currentNode = soapMessage.getSOAPBody().addChildElement(methodName, "namesp1", "ServiceSOAP");
        currentNode = currentNode.addChildElement("c-gensym3").addAttribute(soapEnvelope.createName("xsi:type"), "apachens:Map");
        for (Object id : ((Map) requestObject).keySet()) {
            SOAPElement itemNode = currentNode.addChildElement("item");
            itemNode.addChildElement("key")
                    .addTextNode(String.valueOf(id));
            itemNode.addChildElement("value")
                    .addTextNode(String.valueOf(((Map) requestObject).get(id)));
        }
    }
}
