package ru.yandex.autotests.directapi.darkside.datacontainers.soap;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

/**
 * Created by omaz on 09.04.14.
 */
public class SetBannerAutobudgetStatusRequest extends BaseSoapRequest {

    public SetBannerAutobudgetStatusRequest(SetBannerAutobudgetShowStatusRequestData params) {
        this.requestObject = params;
        this.requestClass = params.getClass();
    }

    @Override
    public void marshallSOAPMessage(SOAPMessage soapMessage) throws SOAPException {
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        soapEnvelope.addNamespaceDeclaration("xsi", "http://www.w3.org/1999/XMLSchema-instance");
        soapEnvelope.addNamespaceDeclaration("apachens", "http://xml.apache.org/xml-soap");
        soapEnvelope.addNamespaceDeclaration("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");

        SOAPElement currentNode = soapMessage.getSOAPBody().addChildElement(methodName, "namesp1", "ServiceSOAP");
        currentNode = currentNode.addChildElement("c-gensym3").addAttribute(soapEnvelope.createName("xsi:type"), "apachens:Map");
        for (Long banner : ((SetBannerAutobudgetShowStatusRequestData) requestObject).data.keySet()) {
            SOAPElement campaignItemNode = currentNode.addChildElement("item");
            campaignItemNode.addChildElement("key")
                    .addTextNode(String.valueOf(banner));
            campaignItemNode.addChildElement("value")
                    .addTextNode(String.valueOf(((SetBannerAutobudgetShowStatusRequestData) requestObject).data.get(banner) ? 1 : 0));
        }
    }
}
